/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import java.io.Closeable;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import redis.clients.jedis.AbstractPipeline;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.CommandObjects;
import redis.clients.jedis.Connection;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.mcf.MultiDbConnectionProvider;
import redis.clients.jedis.mcf.MultiDbConnectionSupplier;
import redis.clients.jedis.util.KeyValue;

@Experimental
public class MultiDbPipeline
extends AbstractPipeline
implements Closeable {
    private final MultiDbConnectionSupplier failoverProvider;
    private final Queue<KeyValue<CommandArguments, Response<?>>> commands = new LinkedList();

    @Deprecated
    public MultiDbPipeline(MultiDbConnectionProvider pooledProvider) {
        super(new CommandObjects());
        this.failoverProvider = new MultiDbConnectionSupplier(pooledProvider);
        try (Connection connection = this.failoverProvider.getConnection();){
            RedisProtocol proto = connection.getRedisProtocol();
            if (proto != null) {
                this.commandObjects.setProtocol(proto);
            }
        }
    }

    public MultiDbPipeline(MultiDbConnectionProvider pooledProvider, CommandObjects commandObjects) {
        super(commandObjects);
        this.failoverProvider = new MultiDbConnectionSupplier(pooledProvider);
    }

    @Override
    protected final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        CommandArguments args = commandObject.getArguments();
        Response<T> response = new Response<T>(commandObject.getBuilder());
        this.commands.add(KeyValue.of(args, response));
        return response;
    }

    @Override
    public void close() {
        this.sync();
    }

    @Override
    public void sync() {
        if (this.commands.isEmpty()) {
            return;
        }
        try (Connection connection = this.failoverProvider.getConnection();){
            this.commands.forEach(command -> connection.sendCommand((CommandArguments)command.getKey()));
            List<Object> unformatted = connection.getMany(this.commands.size());
            unformatted.forEach(rawReply -> ((Response)this.commands.poll().getValue()).set(rawReply));
        }
    }

    public Response<Long> waitReplicas(int replicas, long timeout) {
        return this.appendCommand(this.commandObjects.waitReplicas(replicas, timeout));
    }

    public Response<KeyValue<Long, Long>> waitAOF(long numLocal, long numReplicas, long timeout) {
        return this.appendCommand(this.commandObjects.waitAOF(numLocal, numReplicas, timeout));
    }
}

