/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;

public class RestoreParams
implements IParams {
    private boolean replace;
    private boolean absTtl;
    private Long idleTime;
    private Long frequency;

    public static RestoreParams restoreParams() {
        return new RestoreParams();
    }

    public RestoreParams replace() {
        this.replace = true;
        return this;
    }

    public RestoreParams absTtl() {
        this.absTtl = true;
        return this;
    }

    public RestoreParams idleTime(long idleTime) {
        this.idleTime = idleTime;
        return this;
    }

    public RestoreParams frequency(long frequency) {
        this.frequency = frequency;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.replace) {
            args.add(Protocol.Keyword.REPLACE.getRaw());
        }
        if (this.absTtl) {
            args.add(Protocol.Keyword.ABSTTL.getRaw());
        }
        if (this.idleTime != null) {
            args.add(Protocol.Keyword.IDLETIME.getRaw());
            args.add(Protocol.toByteArray(this.idleTime));
        }
        if (this.frequency != null) {
            args.add(Protocol.Keyword.FREQ.getRaw());
            args.add(Protocol.toByteArray(this.frequency));
        }
    }
}

