/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.enterprise.concurrent.LastExecution;
import javax.enterprise.concurrent.Trigger;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.jboss.as.ee.concurrent.ControlPointUtils;
import org.jboss.as.ee.concurrent.ManagedExecutorRuntimeStats;
import org.jboss.as.ee.concurrent.ManagedExecutorRuntimeStatsImpl;
import org.jboss.as.ee.concurrent.ManagedExecutorWithHungThreads;
import org.jboss.as.ee.concurrent.ManagedThreadFactoryImpl;
import org.jboss.as.ee.concurrent.SecurityIdentityUtils;
import org.wildfly.extension.requestcontroller.ControlPoint;

public class ManagedScheduledExecutorServiceImpl
extends org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceImpl
implements ManagedExecutorWithHungThreads {
    private final ControlPoint controlPoint;
    private final ManagedExecutorRuntimeStats runtimeStats;

    public ManagedScheduledExecutorServiceImpl(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy, ControlPoint controlPoint) {
        super(name, (org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl)managedThreadFactory, hungTaskThreshold, longRunningTasks, corePoolSize, keepAliveTime, keepAliveTimeUnit, threadLifeTime, contextService, rejectPolicy);
        this.controlPoint = controlPoint;
        this.runtimeStats = new ManagedExecutorRuntimeStatsImpl(this);
    }

    public void execute(Runnable command) {
        super.execute(SecurityIdentityUtils.doIdentityWrap(ControlPointUtils.doWrap(command, this.controlPoint)));
    }

    public Future<?> submit(Runnable task) {
        return super.submit(SecurityIdentityUtils.doIdentityWrap(ControlPointUtils.doWrap(task, this.controlPoint)));
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return super.submit(SecurityIdentityUtils.doIdentityWrap(ControlPointUtils.doWrap(task, this.controlPoint)), result);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(SecurityIdentityUtils.doIdentityWrap(ControlPointUtils.doWrap(task, this.controlPoint)));
    }

    public ScheduledFuture<?> schedule(Runnable command, Trigger trigger) {
        CancellableTrigger ctrigger = new CancellableTrigger(trigger);
        ctrigger.future = super.schedule(SecurityIdentityUtils.doIdentityWrap(ControlPointUtils.doScheduledWrap(command, this.controlPoint)), (Trigger)ctrigger);
        return ctrigger.future;
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, Trigger trigger) {
        CancellableTrigger ctrigger = new CancellableTrigger(trigger);
        ctrigger.future = super.schedule(SecurityIdentityUtils.doIdentityWrap(ControlPointUtils.doScheduledWrap(callable, this.controlPoint)), (Trigger)ctrigger);
        return ctrigger.future;
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return super.schedule(SecurityIdentityUtils.doIdentityWrap(ControlPointUtils.doScheduledWrap(command, this.controlPoint)), delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return super.schedule(SecurityIdentityUtils.doIdentityWrap(ControlPointUtils.doScheduledWrap(callable, this.controlPoint)), delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(SecurityIdentityUtils.doIdentityWrap(ControlPointUtils.doScheduledWrap(command, this.controlPoint)), initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(SecurityIdentityUtils.doIdentityWrap(ControlPointUtils.doScheduledWrap(command, this.controlPoint)), initialDelay, delay, unit);
    }

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return (ThreadPoolExecutor)super.getThreadPoolExecutor();
    }

    public ManagedExecutorRuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    private static class CancellableTrigger
    implements Trigger {
        private final Trigger trigger;
        private ScheduledFuture future;

        CancellableTrigger(Trigger trigger) {
            this.trigger = trigger;
        }

        public Date getNextRunTime(LastExecution lastExecution, Date taskScheduledTime) {
            Date nextRunTime = this.trigger.getNextRunTime(lastExecution, taskScheduledTime);
            ScheduledFuture future = this.future;
            if (future != null && future.isCancelled()) {
                nextRunTime = null;
            }
            return nextRunTime;
        }

        public boolean skipRun(LastExecution lastExecution, Date date) {
            return this.trigger.skipRun(lastExecution, date);
        }
    }
}

