/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.EnumSet;
import java.util.Iterator;
import org.wildfly.security.ssl.CipherSuitePredicate;
import org.wildfly.security.ssl.Encryption;
import org.wildfly.security.ssl.MechanismDatabase;

final class EncryptionCipherSuitePredicate
extends CipherSuitePredicate {
    private final EnumSet<Encryption> set;

    EncryptionCipherSuitePredicate(EnumSet<Encryption> set) {
        this.set = set;
    }

    @Override
    void toString(StringBuilder b) {
        b.append("encryption is one of (");
        Iterator iterator = this.set.iterator();
        if (iterator.hasNext()) {
            Encryption encryption = (Encryption)((Object)iterator.next());
            b.append((Object)encryption);
            while (iterator.hasNext()) {
                encryption = (Encryption)((Object)iterator.next());
                b.append(", ");
                b.append((Object)encryption);
            }
        }
        b.append(')');
    }

    @Override
    public boolean test(MechanismDatabase.Entry entry) {
        return this.set.contains((Object)entry.getEncryption());
    }

    @Override
    boolean isAlwaysTrue() {
        return this.set.size() == Encryption.fullSize;
    }

    @Override
    boolean isAlwaysFalse() {
        return this.set.isEmpty();
    }
}

