/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective.cec2005competitioncode;

import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.Benchmark;
import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.TestFunc;
import org.uma.jmetal.util.JMetalException;

public class F11ShiftedRotatedWeierstrass
extends TestFunc {
    public static final String FUNCTION_NAME = "Shifted Rotated Weierstrass Function";
    public static final String DEFAULT_FILE_DATA = "cec2005CompetitionResources/supportData/weierstrass_data.txt";
    public static final String DEFAULT_FILE_MX_PREFIX = "cec2005CompetitionResources/supportData/weierstrass_M_D";
    public static final String DEFAULT_FILE_MX_SUFFIX = ".txt";
    public static final double PIx2 = Math.PI * 2;
    public static final int Kmax = 20;
    public static final double a = 0.5;
    public static final double b = 3.0;
    private final double[] m_o;
    private final double[][] m_matrix;
    private double[] m_z;
    private double[] m_zM;

    public F11ShiftedRotatedWeierstrass(int dimension, double bias) throws JMetalException {
        this(dimension, bias, DEFAULT_FILE_DATA, DEFAULT_FILE_MX_PREFIX + dimension + DEFAULT_FILE_MX_SUFFIX);
    }

    public F11ShiftedRotatedWeierstrass(int dimension, double bias, String file_data, String file_m) throws JMetalException {
        super(dimension, bias, FUNCTION_NAME);
        this.m_o = new double[this.mDimension];
        this.m_matrix = new double[this.mDimension][this.mDimension];
        this.m_z = new double[this.mDimension];
        this.m_zM = new double[this.mDimension];
        Benchmark.loadRowVectorFromFile(file_data, this.mDimension, this.m_o);
        Benchmark.loadMatrixFromFile(file_m, this.mDimension, this.mDimension, this.m_matrix);
    }

    @Override
    public double f(double[] x) {
        double result = 0.0;
        Benchmark.shift(this.m_z, x, this.m_o);
        Benchmark.xA(this.m_zM, this.m_z, this.m_matrix);
        result = Benchmark.weierstrass(this.m_zM);
        return result += this.mBias;
    }
}

