/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective;

import org.uma.jmetal.problem.sequenceproblem.impl.CharSequenceProblem;
import org.uma.jmetal.solution.sequencesolution.impl.CharSequenceSolution;
import org.uma.jmetal.util.checking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class StringMatching
extends CharSequenceProblem {
    private String targetString;
    private final char[] alphabet;

    public StringMatching(String targetString, String alphabet) {
        this.targetString = targetString;
        this.alphabet = alphabet.toCharArray();
        this.setNumberOfVariables(targetString.length());
        this.setNumberOfObjectives(1);
        this.setNumberOfConstraints(0);
        this.setName("String Match");
    }

    public StringMatching(String targetString) {
        this(targetString, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890, .-;:_!\"#%&/()=?@${[]}");
    }

    public int getLength() {
        return this.targetString.length();
    }

    public void evaluate(CharSequenceSolution solution) {
        Check.that((solution.getLength() == this.targetString.length() ? 1 : 0) != 0, (String)"The solution has an invalid length");
        int counter = 0;
        for (int i = 0; i < this.targetString.length(); ++i) {
            if (this.targetString.charAt(i) == ((Character)solution.getVariable(i)).charValue()) continue;
            ++counter;
        }
        solution.setObjective(0, (double)counter);
    }

    public CharSequenceSolution createSolution() {
        CharSequenceSolution solution = new CharSequenceSolution(this.targetString.length(), this.getNumberOfObjectives());
        for (int i = 0; i < this.targetString.length(); ++i) {
            solution.setVariable(i, (Object)Character.valueOf(this.alphabet[JMetalRandom.getInstance().nextInt(0, this.alphabet.length - 1)]));
        }
        return solution;
    }

    public char[] getAlphabet() {
        return this.alphabet;
    }
}

