/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class Rastrigin
extends AbstractDoubleProblem {
    public Rastrigin(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(1);
        this.setNumberOfConstraints(0);
        this.setName("Rastrigin");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-5.12);
            upperLimit.add(5.12);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        int numberOfVariables = this.getNumberOfVariables();
        double[] x = new double[numberOfVariables];
        for (int i = 0; i < numberOfVariables; ++i) {
            x[i] = (Double)solution.getVariable(i);
        }
        double result = 0.0;
        double a = 10.0;
        double w = Math.PI * 2;
        for (int i = 0; i < numberOfVariables; ++i) {
            result += x[i] * x[i] - a * Math.cos(w * x[i]);
        }
        solution.setObjective(0, result += a * (double)numberOfVariables);
    }
}

