/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.zdt;

import org.uma.jmetal.problem.multiobjective.zdt.ZDT1;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class ZDT6
extends ZDT1 {
    public ZDT6() {
        this(10);
    }

    public ZDT6(Integer numberOfVariables) {
        super(numberOfVariables);
        this.setName("ZDT6");
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        double[] f = new double[this.getNumberOfObjectives()];
        double x1 = (Double)solution.getVariable(0);
        f[0] = 1.0 - Math.exp(-4.0 * x1) * Math.pow(Math.sin(Math.PI * 6 * x1), 6.0);
        double g = this.evalG(solution);
        double h = this.evalH(f[0], g);
        f[1] = h * g;
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }

    @Override
    protected double evalG(DoubleSolution solution) {
        double g = 0.0;
        for (int var = 1; var < solution.getNumberOfVariables(); ++var) {
            g += ((Double)solution.getVariable(var)).doubleValue();
        }
        g /= (double)(solution.getNumberOfVariables() - 1);
        g = Math.pow(g, 0.25);
        g = 9.0 * g;
        g = 1.0 + g;
        return g;
    }

    @Override
    protected double evalH(double f, double g) {
        return 1.0 - Math.pow(f / g, 2.0);
    }
}

