/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.zdt;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.uma.jmetal.problem.binaryproblem.impl.AbstractBinaryProblem;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.util.checking.Check;

public class ZDT5
extends AbstractBinaryProblem {
    private List<Integer> bitsPerVariable;

    public ZDT5() {
        this(11);
    }

    public ZDT5(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setName("ZDT5");
        this.bitsPerVariable = new ArrayList<Integer>(numberOfVariables);
        this.bitsPerVariable.add(30);
        for (int var = 1; var < numberOfVariables; ++var) {
            this.bitsPerVariable.add(5);
        }
    }

    public List<Integer> getListOfBitsPerVariable() {
        return this.bitsPerVariable;
    }

    public int getBitsFromVariable(int index) {
        Check.valueIsInRange((int)index, (int)0, (int)this.getNumberOfVariables());
        return this.bitsPerVariable.get(index);
    }

    public void evaluate(BinarySolution solution) {
        double[] f = new double[solution.getNumberOfObjectives()];
        f[0] = 1.0 + this.u((BitSet)solution.getVariable(0));
        double g = this.evalG(solution);
        double h = this.evalH(f[0], g);
        f[1] = h * g;
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }

    public double evalG(BinarySolution solution) {
        double res = 0.0;
        for (int i = 1; i < solution.getNumberOfVariables(); ++i) {
            res += this.evalV(this.u((BitSet)solution.getVariable(i)));
        }
        return res;
    }

    public double evalV(double value) {
        if (value < 5.0) {
            return 2.0 + value;
        }
        return 1.0;
    }

    public double evalH(double f, double g) {
        return 1.0 / f;
    }

    private double u(BitSet bitset) {
        return bitset.cardinality();
    }
}

