/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.wfg;

import org.uma.jmetal.problem.multiobjective.wfg.Shapes;
import org.uma.jmetal.problem.multiobjective.wfg.Transformations;
import org.uma.jmetal.problem.multiobjective.wfg.WFG;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class WFG9
extends WFG {
    public WFG9() {
        this(2, 4, 2);
    }

    public WFG9(Integer k, Integer l, Integer m) {
        super(k, l, m);
        int i;
        this.setName("WFG9");
        this.s = new int[m.intValue()];
        for (i = 0; i < m; ++i) {
            this.s[i] = 2 * (i + 1);
        }
        this.a = new int[m - 1];
        for (i = 0; i < m - 1; ++i) {
            this.a[i] = 1;
        }
    }

    @Override
    public float[] evaluate(float[] z) {
        float[] y = this.normalise(z);
        y = this.t1(y, this.k);
        y = this.t2(y, this.k);
        y = this.t3(y, this.k, this.m);
        float[] result = new float[this.m];
        float[] x = this.calculateX(y);
        for (int m = 1; m <= this.m; ++m) {
            result[m - 1] = (float)this.d * x[this.m - 1] + (float)this.s[m - 1] * new Shapes().concave(x, m);
        }
        return result;
    }

    public float[] t1(float[] z, int k) {
        int i;
        float[] result = new float[z.length];
        float[] w = new float[z.length];
        for (i = 0; i < w.length; ++i) {
            w[i] = 1.0f;
        }
        for (i = 0; i < z.length - 1; ++i) {
            int head = i + 1;
            int tail = z.length - 1;
            float[] subZ = this.subVector(z, head, tail);
            float[] subW = this.subVector(w, head, tail);
            float aux = new Transformations().rSum(subZ, subW);
            result[i] = new Transformations().bParam(z[i], aux, 0.019607844f, 0.02f, 50.0f);
        }
        result[z.length - 1] = z[z.length - 1];
        return result;
    }

    public float[] t2(float[] z, int k) {
        int i;
        float[] result = new float[z.length];
        for (i = 0; i < k; ++i) {
            result[i] = new Transformations().sDecept(z[i], 0.35f, 0.001f, 0.05f);
        }
        for (i = k; i < z.length; ++i) {
            result[i] = new Transformations().sMulti(z[i], 30, 95, 0.35f);
        }
        return result;
    }

    public float[] t3(float[] z, int k, int M) {
        float[] subZ;
        float[] result = new float[M];
        for (int i = 1; i <= M - 1; ++i) {
            int head = (i - 1) * k / (M - 1) + 1;
            int tail = i * k / (M - 1);
            subZ = this.subVector(z, head - 1, tail - 1);
            result[i - 1] = new Transformations().rNonsep(subZ, k / (M - 1));
        }
        int head = k + 1;
        int tail = z.length;
        int l = z.length - k;
        subZ = this.subVector(z, head - 1, tail - 1);
        result[M - 1] = new Transformations().rNonsep(subZ, l);
        return result;
    }

    public void evaluate(DoubleSolution solution) {
        int i;
        float[] variables = new float[this.getNumberOfVariables()];
        double[] x = new double[this.getNumberOfVariables()];
        for (i = 0; i < this.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariable(i);
        }
        for (i = 0; i < this.getNumberOfVariables(); ++i) {
            variables[i] = (float)x[i];
        }
        float[] sol2 = this.evaluate(variables);
        for (int i2 = 0; i2 < sol2.length; ++i2) {
            solution.setObjective(i2, (double)sol2[i2]);
        }
    }
}

