/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.mop;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class MOP1
extends AbstractDoubleProblem {
    public MOP1() {
        this(10);
    }

    public MOP1(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setName("MOP1");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        double[] f = new double[this.getNumberOfObjectives()];
        double g = this.evalG(solution);
        f[0] = (1.0 + g) * (Double)solution.getVariable(0);
        f[1] = (1.0 + g) * (1.0 - Math.sqrt((Double)solution.getVariable(0)));
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }

    private double evalG(DoubleSolution solution) {
        double g = 0.0;
        for (int i = 1; i < solution.getNumberOfVariables(); ++i) {
            double t = (Double)solution.getVariable(i) - Math.sin(1.5707963267948966 * (Double)solution.getVariable(0));
            g += -0.9 * t * t + Math.pow(Math.abs(t), 0.6);
        }
        g = 2.0 * Math.sin(Math.PI * (Double)solution.getVariable(0)) * g;
        return g;
    }
}

