/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.maf;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class MaF11
extends AbstractDoubleProblem {
    public int K11;
    public int L11;

    public MaF11() {
        this(12, 3);
    }

    public MaF11(Integer numberOfVariables, Integer numberOfObjectives) {
        this.setNumberOfVariables((int)(Math.ceil((double)(numberOfVariables - numberOfObjectives + 1) / 2.0) * 2.0 + (double)numberOfObjectives.intValue() - 1.0));
        this.setNumberOfObjectives(numberOfObjectives);
        this.setNumberOfConstraints(0);
        this.setName("MaF11");
        this.K11 = numberOfObjectives - 1;
        this.L11 = numberOfVariables - this.K11;
        ArrayList<Double> lower = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upper = new ArrayList<Double>(this.getNumberOfVariables());
        for (int var = 0; var < numberOfVariables; ++var) {
            lower.add(0.0);
            upper.add(2.0 * (double)(var + 1));
        }
        this.setVariableBounds(lower, upper);
    }

    public void evaluate(DoubleSolution solution) {
        int i;
        int i2;
        int numberOfVariables = solution.getNumberOfVariables();
        int numberOfObjectives = solution.getNumberOfObjectives();
        double[] x = new double[numberOfVariables];
        double[] f = new double[numberOfObjectives];
        for (int i3 = 0; i3 < numberOfVariables; ++i3) {
            x[i3] = (Double)solution.getVariable(i3);
        }
        double[] z = new double[numberOfVariables];
        double[] t1 = new double[numberOfVariables];
        double[] t2 = new double[(numberOfVariables + this.K11) / 2];
        double[] t3 = new double[numberOfObjectives];
        double[] y = new double[numberOfObjectives];
        double sub1 = 0.0;
        double sub2 = 0.0;
        int lb = 0;
        int ub = 0;
        for (i2 = 0; i2 < this.K11; ++i2) {
            z[i2] = x[i2] / (double)(2 * i2 + 2);
            t1[i2] = z[i2];
            t2[i2] = t1[i2];
        }
        for (i2 = this.K11; i2 < numberOfVariables; ++i2) {
            z[i2] = x[i2] / (double)(2 * i2 + 2);
            t1[i2] = Math.abs(z[i2] - 0.35) / Math.abs(Math.floor(0.35 - z[i2]) + 0.35);
        }
        for (i2 = this.K11; i2 < t2.length; ++i2) {
            t2[i2] = (t1[2 * i2 - this.K11] + t1[2 * i2 - this.K11 + 1] + 2.0 * Math.abs(t1[2 * i2 - this.K11] - t1[2 * i2 - this.K11 + 1])) / 3.0;
        }
        sub2 = this.K11 / (numberOfObjectives - 1);
        for (i2 = 0; i2 < numberOfObjectives - 1; ++i2) {
            sub1 = 0.0;
            lb = i2 * this.K11 / (numberOfObjectives - 1) + 1;
            ub = (i2 + 1) * this.K11 / (numberOfObjectives - 1);
            for (int j = lb - 1; j < ub; ++j) {
                sub1 += t2[j];
            }
            t3[i2] = sub1 / sub2;
        }
        lb = this.K11 + 1;
        ub = (numberOfVariables + this.K11) / 2;
        sub1 = 0.0;
        sub2 = (numberOfVariables - this.K11) / 2;
        for (int j = lb - 1; j < ub; ++j) {
            sub1 += t2[j];
        }
        t3[numberOfObjectives - 1] = sub1 / sub2;
        for (i2 = 0; i2 < numberOfObjectives - 1; ++i2) {
            y[i2] = (t3[i2] - 0.5) * Math.max(1.0, t3[numberOfObjectives - 1]) + 0.5;
        }
        y[numberOfObjectives - 1] = t3[numberOfObjectives - 1];
        double subf1 = 1.0;
        f[numberOfObjectives - 1] = y[numberOfObjectives - 1] + (double)(2 * numberOfObjectives) * (1.0 - y[0] * Math.pow(Math.cos(Math.PI * 5 * y[0]), 2.0));
        for (i = numberOfObjectives - 2; i > 0; --i) {
            f[i] = y[numberOfObjectives - 1] + (double)(2 * (i + 1)) * (subf1 *= 1.0 - Math.cos(Math.PI * y[numberOfObjectives - i - 2] / 2.0)) * (1.0 - Math.sin(Math.PI * y[numberOfObjectives - i - 1] / 2.0));
        }
        f[0] = y[numberOfObjectives - 1] + 2.0 * subf1 * (1.0 - Math.cos(Math.PI * y[numberOfObjectives - 2] / 2.0));
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

