/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.maf;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class MaF09
extends AbstractDoubleProblem {
    public int maxinter9;
    public int[] pindex9;
    public int M9;
    public double[][] points9;
    public double[][] rangex9;
    public double[][] rangey9;
    public double[][] r_polyline9;
    public double[][] oth_poly_points9;

    public MaF09() {
        this(2, 10);
    }

    public MaF09(Integer numberOfVariables, Integer numberOfObjectives) {
        int maxinterval;
        this.setNumberOfVariables(2);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setNumberOfConstraints(0);
        this.setName("MaF09");
        this.M9 = numberOfObjectives;
        double r = 1.0;
        double[][] p = MaF09.polygonpoints(numberOfObjectives, r);
        this.points9 = p;
        double[][] rx9 = new double[numberOfObjectives.intValue()][2];
        double[][] ry9 = new double[numberOfObjectives.intValue()][2];
        for (int i = 0; i < numberOfObjectives - 1; ++i) {
            rx9[i][0] = p[i][0] <= p[i + 1][0] ? p[i][0] : p[i + 1][0];
            rx9[i][1] = p[i][0] <= p[i + 1][0] ? p[i + 1][0] : p[i][0];
            ry9[i][0] = p[i][1] <= p[i + 1][1] ? p[i][1] : p[i + 1][1];
            ry9[i][1] = p[i][1] <= p[i + 1][1] ? p[i + 1][1] : p[i][1];
        }
        rx9[numberOfObjectives.intValue() - 1][0] = p[numberOfObjectives - 1][0] <= p[0][0] ? p[numberOfObjectives - 1][0] : p[0][0];
        rx9[numberOfObjectives.intValue() - 1][1] = p[numberOfObjectives - 1][0] <= p[0][0] ? p[0][0] : p[numberOfObjectives - 1][0];
        ry9[numberOfObjectives.intValue() - 1][0] = p[numberOfObjectives - 1][1] <= p[0][1] ? p[numberOfObjectives - 1][1] : p[0][1];
        ry9[numberOfObjectives.intValue() - 1][1] = p[numberOfObjectives - 1][1] <= p[0][1] ? p[0][1] : p[numberOfObjectives - 1][1];
        this.rangex9 = rx9;
        this.rangey9 = ry9;
        double[][] c9 = this.lines_of_polygon(p);
        this.r_polyline9 = c9;
        this.maxinter9 = maxinterval = (int)Math.ceil((double)numberOfObjectives.intValue() / 2.0 - 2.0);
        int lenp = 0;
        for (int i = 2; i <= 1 + maxinterval; ++i) {
            lenp += i;
        }
        double[][] opoly9 = new double[lenp *= numberOfObjectives * 2][2];
        int[] head = new int[maxinterval * numberOfObjectives];
        int[] tail = new int[maxinterval * numberOfObjectives];
        for (int i = 0; i < maxinterval; ++i) {
            for (int j = 0; j < numberOfObjectives; ++j) {
                head[i * numberOfObjectives.intValue() + j] = j;
                tail[i * numberOfObjectives.intValue() + j] = j + i + 1;
            }
        }
        int[] v4 = new int[4];
        double[] kb1 = new double[3];
        double[] kb2 = new double[3];
        double[] interp = new double[2];
        int[] pind = new int[head.length + 1];
        int ic = 0;
        for (int i = 0; i < head.length; ++i) {
            int tv;
            int j;
            pind[i] = ic;
            v4[0] = head[i] - 1;
            v4[1] = head[i];
            v4[2] = tail[i];
            v4[3] = tail[i] + 1;
            for (j = 0; j < 4; ++j) {
                v4[j] = (v4[j] + numberOfObjectives) % numberOfObjectives;
            }
            kb1 = MaF09.line_of_twoP(p[v4[0]], p[v4[1]]);
            kb2 = MaF09.line_of_twoP(p[v4[2]], p[v4[3]]);
            interp = MaF09.intersection(kb1, kb2);
            for (j = head[i]; j <= tail[i]; ++j) {
                tv = (j + numberOfObjectives) % numberOfObjectives;
                opoly9[ic] = p[tv];
                ++ic;
            }
            for (j = head[i]; j <= tail[i]; ++j) {
                tv = (j + numberOfObjectives) % numberOfObjectives;
                opoly9[ic][0] = 2.0 * interp[0] - p[tv][0];
                opoly9[ic][1] = 2.0 * interp[1] - p[tv][1];
                ++ic;
            }
        }
        pind[pind.length - 1] = ic;
        this.pindex9 = pind;
        this.oth_poly_points9 = opoly9;
        ArrayList<Double> lower = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upper = new ArrayList<Double>(this.getNumberOfVariables());
        for (int var = 0; var < numberOfVariables; ++var) {
            lower.add(-10000.0);
            upper.add(10000.0);
        }
        this.setVariableBounds(lower, upper);
    }

    public void evaluate(DoubleSolution solution) {
        int i;
        int numberOfVariables_ = solution.getNumberOfVariables();
        int numberOfObjectives = solution.getNumberOfObjectives();
        double[] x = new double[numberOfVariables_];
        double[] f = new double[numberOfObjectives];
        for (int i2 = 0; i2 < numberOfVariables_; ++i2) {
            x[i2] = (Double)solution.getVariable(i2);
        }
        boolean infeasible = false;
        infeasible = this.if_infeasible(x);
        while (infeasible) {
            for (i = 0; i < numberOfVariables_; ++i) {
                x[i] = MaF09.generV(this.getLowerBound(i), this.getUpperBound(i));
                solution.setVariable(i, (Object)x[i]);
            }
            infeasible = this.if_infeasible(x);
        }
        for (i = 0; i < this.M9 - 1; ++i) {
            f[i] = this.r_polyline9[i][0] == 1.0 ? Math.abs(x[0] - this.r_polyline9[i][1]) : Math.abs(this.r_polyline9[i][1] * x[0] - x[1] + this.r_polyline9[i][2]) / Math.sqrt(Math.pow(this.r_polyline9[i][1], 2.0) + 1.0);
        }
        f[this.M9 - 1] = this.r_polyline9[this.M9 - 1][0] == 1.0 ? Math.abs(x[0] - this.r_polyline9[this.M9 - 1][1]) : Math.abs(this.r_polyline9[this.M9 - 1][1] * x[0] - x[1] + this.r_polyline9[this.M9 - 1][2]) / Math.sqrt(Math.pow(this.r_polyline9[this.M9 - 1][1], 2.0) + 1.0);
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.setObjective(i, f[i]);
        }
    }

    public static double[][] polygonpoints(int m, double r) {
        int i;
        double[][] p = new double[m][2];
        double[] angle = new double[m];
        double thera = 1.5707963267948966;
        double rho = r;
        for (i = 0; i < m; ++i) {
            angle[i] = thera - (double)(2 * (i + 1)) * Math.PI / (double)m;
        }
        for (i = 0; i < m; ++i) {
            p[i][0] = rho * Math.cos(angle[i]);
            p[i][1] = rho * Math.sin(angle[i]);
        }
        return p;
    }

    public static double[] line_of_twoP(double[] p1, double[] p2) {
        double[] kb = new double[3];
        if (p1[0] == p2[0]) {
            kb[0] = 1.0;
            kb[1] = p1[0];
            kb[2] = 0.0;
        } else {
            kb[0] = 0.0;
            kb[1] = (p1[1] - p2[1]) / (p1[0] - p2[0]);
            kb[2] = p1[1] - kb[1] * p1[0];
        }
        return kb;
    }

    public double[][] lines_of_polygon(double[][] p) {
        double[][] c9 = new double[p.length][3];
        for (int i = 0; i < p.length - 1; ++i) {
            c9[i] = MaF09.line_of_twoP(p[i], p[i + 1]);
        }
        c9[p.length - 1] = MaF09.line_of_twoP(p[p.length - 1], p[0]);
        return c9;
    }

    public static double[] intersection(double[] kb1, double[] kb2) {
        double[] interp = new double[2];
        if (kb1[0] == 1.0) {
            interp[0] = kb1[1];
            interp[1] = kb2[1] * interp[0] + kb2[2];
        } else if (kb2[0] == 1.0) {
            interp[0] = kb2[1];
            interp[1] = kb1[1] * interp[0] + kb1[2];
        } else {
            interp[0] = (kb2[2] - kb1[2]) / (kb1[1] - kb2[1]);
            interp[1] = kb1[1] * interp[0] + kb1[2];
        }
        return interp;
    }

    public boolean if_infeasible(double[] x) {
        int i;
        boolean infeasible = false;
        for (i = 0; i < this.pindex9.length - 1; ++i) {
            double[][] p = new double[this.pindex9[i + 1] - this.pindex9[i]][2];
            for (int j = this.pindex9[i]; j < this.pindex9[i + 1]; ++j) {
                p[j - this.pindex9[i]] = this.oth_poly_points9[j];
            }
            infeasible = MaF09.if_inside_polygon(x, p);
            if (infeasible) break;
        }
        if (infeasible) {
            for (i = 0; i < this.r_polyline9.length - 1; ++i) {
                if (this.r_polyline9[i][0] == 1.0) {
                    if (x[0] != this.r_polyline9[i][1] || !(x[1] >= this.rangey9[i][0]) || !(x[1] <= this.rangey9[i][1])) continue;
                    infeasible = false;
                    break;
                }
                if (x[0] * this.r_polyline9[i][1] + this.r_polyline9[i][2] != x[1] || !(x[1] >= this.rangey9[i][0]) || !(x[1] <= this.rangey9[i][1]) || !(x[0] >= this.rangex9[i][0]) || !(x[0] <= this.rangex9[i][1])) continue;
                infeasible = false;
                break;
            }
            if (this.r_polyline9[this.M9 - 1][0] == 1.0) {
                if (x[0] == this.r_polyline9[this.M9 - 1][1] && x[1] >= this.rangey9[this.M9 - 1][0] && x[1] <= this.rangey9[this.M9 - 1][1]) {
                    infeasible = false;
                }
            } else if (x[0] * this.r_polyline9[this.M9 - 1][1] + this.r_polyline9[this.M9 - 1][2] == x[1] && x[1] >= this.rangey9[this.M9 - 1][0] && x[1] <= this.rangey9[this.M9 - 1][1] && x[0] >= this.rangex9[this.M9 - 1][0] && x[0] <= this.rangex9[this.M9 - 1][1]) {
                infeasible = false;
            }
        }
        return infeasible;
    }

    public static boolean if_inside_polygon(double[] p1, double[][] points) {
        ArrayList<Point2D.Double> polygon = new ArrayList<Point2D.Double>();
        Point2D.Double p = new Point2D.Double(p1[0], p1[1]);
        for (int i = 0; i < points.length; ++i) {
            polygon.add(new Point2D.Double(points[i][0], points[i][1]));
        }
        boolean ifin = MaF09.checkWithJdkGeneralPath(p, polygon);
        return ifin;
    }

    public static boolean checkWithJdkGeneralPath(Point2D.Double point, List<Point2D.Double> polygon) {
        GeneralPath p = new GeneralPath();
        Point2D.Double first = polygon.get(0);
        p.moveTo(first.x, first.y);
        polygon.remove(0);
        for (Point2D.Double d : polygon) {
            p.lineTo(d.x, d.y);
        }
        p.lineTo(first.x, first.y);
        p.closePath();
        return p.contains(point);
    }

    public static double generV(double lb, double ub) {
        double p = JMetalRandom.getInstance().nextDouble() * (ub - lb) + lb;
        return p;
    }
}

