/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.maf;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class MaF07
extends AbstractDoubleProblem {
    public MaF07() {
        this(22, 3);
    }

    public MaF07(Integer numberOfVariables, Integer numberOfObjectives) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setNumberOfConstraints(0);
        this.setName("MaF07");
        ArrayList<Double> lower = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upper = new ArrayList<Double>(this.getNumberOfVariables());
        for (int var = 0; var < numberOfVariables; ++var) {
            lower.add(0.0);
            upper.add(1.0);
        }
        this.setVariableBounds(lower, upper);
    }

    public void evaluate(DoubleSolution solution) {
        int i;
        int numberOfVariables = solution.getNumberOfVariables();
        int numberOfObjectives = solution.getNumberOfObjectives();
        double[] x = new double[numberOfVariables];
        double[] f = new double[numberOfObjectives];
        for (int i2 = 0; i2 < numberOfVariables; ++i2) {
            x[i2] = (Double)solution.getVariable(i2);
        }
        double g = 0.0;
        double h = 0.0;
        for (i = numberOfObjectives - 1; i < numberOfVariables; ++i) {
            g += x[i];
        }
        g = 1.0 + 9.0 * g / (double)(numberOfVariables - numberOfObjectives + 1);
        double sub1 = 1.0 + g;
        for (i = 0; i < numberOfObjectives - 1; ++i) {
            h += x[i] * (1.0 + Math.sin(Math.PI * 3 * x[i])) / sub1;
        }
        h = (double)numberOfObjectives - h;
        for (i = 0; i < numberOfObjectives; ++i) {
            f[i] = x[i];
        }
        f[numberOfObjectives - 1] = h * sub1;
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

