/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.maf;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class MaF02
extends AbstractDoubleProblem {
    public int const2;

    public MaF02() {
        this(12, 3);
    }

    public MaF02(Integer numberOfVariables, Integer numberOfObjectives) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setNumberOfConstraints(0);
        this.setName("MaF02");
        this.const2 = (int)Math.floor((double)(numberOfVariables - numberOfObjectives + 1) / (double)numberOfObjectives.intValue());
        ArrayList<Double> lower = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upper = new ArrayList<Double>(this.getNumberOfVariables());
        for (int var = 0; var < numberOfVariables; ++var) {
            lower.add(0.0);
            upper.add(1.0);
        }
        this.setVariableBounds(lower, upper);
    }

    public void evaluate(DoubleSolution solution) {
        int i;
        int ub;
        int lb;
        int numberOfVariables = solution.getNumberOfVariables();
        int numberOfObjectives = solution.getNumberOfObjectives();
        double[] x = new double[numberOfVariables];
        double[] f = new double[numberOfObjectives];
        for (int i2 = 0; i2 < numberOfVariables; ++i2) {
            x[i2] = (Double)solution.getVariable(i2);
        }
        double[] g = new double[numberOfObjectives];
        double[] thet = new double[numberOfObjectives - 1];
        for (int i3 = 0; i3 < numberOfObjectives - 1; ++i3) {
            g[i3] = 0.0;
            lb = numberOfObjectives + i3 * this.const2;
            ub = numberOfObjectives + (i3 + 1) * this.const2 - 1;
            for (int j = lb - 1; j < ub; ++j) {
                int n = i3;
                g[n] = g[n] + Math.pow(x[j] / 2.0 - 0.25, 2.0);
            }
            thet[i3] = 1.5707963267948966 * (x[i3] / 2.0 + 0.25);
        }
        lb = numberOfObjectives + (numberOfObjectives - 1) * this.const2;
        ub = numberOfVariables;
        for (int j = lb - 1; j < ub; ++j) {
            int n = numberOfObjectives - 1;
            g[n] = g[n] + Math.pow(x[j] / 2.0 - 0.25, 2.0);
        }
        f[numberOfObjectives - 1] = Math.sin(thet[0]) * (1.0 + g[numberOfObjectives - 1]);
        double subf1 = 1.0;
        for (i = numberOfObjectives - 2; i > 0; --i) {
            f[i] = (subf1 *= Math.cos(thet[numberOfObjectives - i - 2])) * Math.sin(thet[numberOfObjectives - i - 1]) * (1.0 + g[i]);
        }
        f[0] = subf1 * Math.cos(thet[numberOfObjectives - 2]) * (1.0 + g[0]);
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

