/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.lircmop;

import org.uma.jmetal.problem.multiobjective.lircmop.LIRCMOP6;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class LIRCMOP8
extends LIRCMOP6 {
    public LIRCMOP8() {
        this(30);
    }

    public LIRCMOP8(int numberOfVariables) {
        super(numberOfVariables);
        this.setNumberOfConstraints(2);
        this.setName("LIRCMOP8");
    }

    @Override
    public void evaluateConstraints(DoubleSolution solution) {
        double r = 0.1;
        double theta = -0.7853981633974483;
        double[] a_array = new double[]{2.0, 2.5, 2.5};
        double[] b_array = new double[]{6.0, 12.0, 10.0};
        double[] xOffset = new double[]{1.2, 2.25, 3.5};
        double[] yOffset = new double[]{1.2, 2.25, 3.5};
        double f1 = solution.getObjective(0);
        double f2 = solution.getObjective(1);
        double[] constraint = new double[this.getNumberOfConstraints()];
        for (int i = 0; i < xOffset.length; ++i) {
            constraint[i] = Math.pow(((f1 - xOffset[i]) * Math.cos(theta) - (f2 - yOffset[i]) * Math.sin(theta)) / a_array[i], 2.0) + Math.pow(((f1 - xOffset[i]) * Math.sin(theta) + (f2 - yOffset[i]) * Math.cos(theta)) / b_array[i], 2.0) - r;
        }
        solution.setConstraint(0, constraint[0]);
        solution.setConstraint(1, constraint[1]);
    }
}

