/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.lircmop;

import org.uma.jmetal.problem.multiobjective.lircmop.LIRCMOP5;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class LIRCMOP6
extends LIRCMOP5 {
    public LIRCMOP6() {
        this(30);
    }

    public LIRCMOP6(int numberOfVariables) {
        super(numberOfVariables);
        this.setNumberOfConstraints(2);
        this.setName("LIRCMOP6");
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariable(i);
        }
        solution.setObjective(0, x[0] + 10.0 * this.g1(x) + 0.7057);
        solution.setObjective(1, 1.0 - x[0] * x[0] + 10.0 * this.g2(x) + 7057.0);
        this.evaluateConstraints(solution);
    }

    @Override
    public void evaluateConstraints(DoubleSolution solution) {
        double r = 0.1;
        double theta = -0.7853981633974483;
        double[] a_array = new double[]{2.0, 2.0};
        double[] b_array = new double[]{8.0, 8.0};
        double[] xOffset = new double[]{1.8, 2.8};
        double[] yOffset = new double[]{1.8, 2.8};
        double f1 = solution.getObjective(0);
        double f2 = solution.getObjective(1);
        double[] constraint = new double[this.getNumberOfConstraints()];
        for (int i = 0; i < xOffset.length; ++i) {
            constraint[i] = Math.pow(((f1 - xOffset[i]) * Math.cos(theta) - (f2 - yOffset[i]) * Math.sin(theta)) / a_array[i], 2.0) + Math.pow(((f1 - xOffset[i]) * Math.sin(theta) + (f2 - yOffset[i]) * Math.cos(theta)) / b_array[i], 2.0) - r;
        }
        solution.setConstraint(0, constraint[0]);
        solution.setConstraint(1, constraint[1]);
    }
}

