/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.lircmop;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class LIRCMOP5
extends AbstractDoubleProblem {
    public LIRCMOP5() {
        this(30);
    }

    public LIRCMOP5(int numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(2);
        this.setName("LIRCMOP5");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariable(i);
        }
        solution.setObjective(0, x[0] + 10.0 * this.g1(x) + 0.7057);
        solution.setObjective(1, 1.0 - Math.sqrt(x[0]) + 10.0 * this.g2(x) + 7057.0);
        this.evaluateConstraints(solution);
    }

    public void evaluateConstraints(DoubleSolution solution) {
        double r = 0.1;
        double theta = -0.7853981633974483;
        double[] a_array = new double[]{2.0, 2.0};
        double[] b_array = new double[]{4.0, 8.0};
        double[] xOffset = new double[]{1.6, 2.5};
        double[] yOffset = new double[]{1.6, 2.5};
        double f1 = solution.getObjective(0);
        double f2 = solution.getObjective(1);
        double[] constraint = new double[this.getNumberOfConstraints()];
        for (int i = 0; i < xOffset.length; ++i) {
            constraint[i] = Math.pow(((f1 - xOffset[i]) * Math.cos(theta) - (f2 - yOffset[i]) * Math.sin(theta)) / a_array[i], 2.0) + Math.pow(((f1 - xOffset[i]) * Math.sin(theta) + (f2 - yOffset[i]) * Math.cos(theta)) / b_array[i], 2.0) - r;
        }
        solution.setConstraint(0, constraint[0]);
        solution.setConstraint(1, constraint[1]);
    }

    protected double g1(double[] x) {
        double result = 0.0;
        for (int i = 2; i < x.length; i += 2) {
            result += Math.pow(x[i] - Math.sin(0.5 * (double)i / (double)x.length * Math.PI * x[0]), 2.0);
        }
        return result;
    }

    protected double g2(double[] x) {
        double result = 0.0;
        for (int i = 1; i < x.length; i += 2) {
            result += Math.pow(x[i] - Math.cos(0.5 * (double)i / (double)x.length * Math.PI * x[0]), 2.0);
        }
        return result;
    }
}

