/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.lircmop;

import org.uma.jmetal.problem.multiobjective.lircmop.LIRCMOP13;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class LIRCMOP14
extends LIRCMOP13 {
    public LIRCMOP14() {
        this(30);
    }

    public LIRCMOP14(int numberOfVariables) {
        super(numberOfVariables);
        this.setNumberOfConstraints(3);
        this.setName("LIRCMOP14");
    }

    @Override
    public void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double f = 0.0;
        for (int i = 0; i < this.getNumberOfObjectives(); ++i) {
            f += Math.pow(solution.getObjective(i), 2.0);
        }
        constraint[0] = (f - 9.0) * (f - 4.0);
        constraint[1] = (f - 3.61) * (f - 3.24);
        constraint[2] = (f - 3.0625) * (f - 2.5600000000000005);
        solution.setConstraint(0, constraint[0]);
        solution.setConstraint(1, constraint[1]);
    }

    @Override
    protected double g1(double[] x) {
        double result = 0.0;
        for (int i = 2; i < this.getNumberOfVariables(); i += 2) {
            result += 10.0 * Math.pow(x[i] - 0.5, 2.0);
        }
        return result;
    }
}

