/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.lircmop;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class LIRCMOP1
extends AbstractDoubleProblem {
    public LIRCMOP1() {
        this(30);
    }

    public LIRCMOP1(int numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(2);
        this.setName("LIRCMOP1");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariable(i);
        }
        solution.setObjective(0, x[0] + this.g1(x));
        solution.setObjective(1, 1.0 - x[0] * x[0] + this.g2(x));
        this.evaluateConstraints(solution);
    }

    public void evaluateConstraints(DoubleSolution solution) {
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariable(i);
        }
        double a = 0.51;
        double b = 0.5;
        solution.setConstraint(0, (0.51 - this.g1(x)) * (this.g1(x) - 0.5));
        solution.setConstraint(1, (0.51 - this.g2(x)) * (this.g2(x) - 0.5));
    }

    protected double g1(double[] x) {
        double result = 0.0;
        for (int i = 2; i < this.getNumberOfVariables(); i += 2) {
            result += Math.pow(x[i] - Math.sin(1.5707963267948966 * x[0]), 2.0);
        }
        return result;
    }

    protected double g2(double[] x) {
        double result = 0.0;
        for (int i = 1; i < this.getNumberOfVariables(); i += 2) {
            result += Math.pow(x[i] - Math.cos(1.5707963267948966 * x[0]), 2.0);
        }
        return result;
    }
}

