/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.fda;

import java.io.Serializable;
import java.util.ArrayList;
import org.uma.jmetal.problem.multiobjective.fda.FDA;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;

public class FDA5
extends FDA
implements Serializable {
    private final int M = 3;

    public FDA5() {
        this(12, 3);
    }

    public FDA5(Integer numberOfVariables, Integer numberOfObjectives) throws JMetalException {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setName("FDA5");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        double[] f = new double[this.getNumberOfObjectives()];
        double g = this.evalG(solution, 2);
        double Ft = 1.0 + 100.0 * Math.pow(Math.sin(1.5707963267948966 * this.time), 4.0);
        f[0] = this.evalF1(solution, g, Ft);
        f[1] = this.evalFK(solution, g, 2, Ft);
        f[2] = this.evalFM(solution, g, Ft);
        for (int i = 0; i < solution.getNumberOfObjectives(); ++i) {
            solution.setObjective(i, f[i]);
        }
    }

    private double evalF1(DoubleSolution solution, double g, double Ft) {
        double f = 1.0 + g;
        double mult = 1.0;
        for (int i = 1; i <= 2; ++i) {
            double y_i = Math.pow((Double)solution.getVariable(i - 1), Ft);
            mult *= Math.cos(y_i * Math.PI / 2.0);
        }
        return f * mult;
    }

    private double evalFK(DoubleSolution solution, double g, int k, double Ft) {
        double f = 1.0 + g;
        double mult = 1.0;
        for (int i = 1; i <= 3 - k; ++i) {
            double y_i = Math.pow((Double)solution.getVariable(i - 1), Ft);
            mult *= Math.cos(y_i * Math.PI / 2.0);
        }
        double yy = Math.pow((Double)solution.getVariable(3 - k), Ft);
        return f * (mult *= Math.sin(yy * Math.PI / 2.0));
    }

    private double evalG(DoubleSolution solution, int limitInf) {
        double g = 0.0;
        double Gt = Math.abs(Math.sin(1.5707963267948966 * this.time));
        for (int i = limitInf; i < solution.getNumberOfVariables(); ++i) {
            g += Math.pow((Double)solution.getVariable(i) - Gt, 2.0);
        }
        return g + Gt;
    }

    private double evalFM(DoubleSolution solution, double g, double Ft) {
        double fm = 1.0 + g;
        double y_1 = Math.pow((Double)solution.getVariable(0), Ft);
        double mult = Math.sin(y_1 * Math.PI / 2.0);
        return fm * mult;
    }
}

