/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.dtlz;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;

public class DTLZ7
extends AbstractDoubleProblem {
    public DTLZ7() {
        this(22, 3);
    }

    public DTLZ7(Integer numberOfVariables, Integer numberOfObjectives) throws JMetalException {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setName("DTLZ7");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        int i;
        int numberOfVariables = this.getNumberOfVariables();
        int numberOfObjectives = this.getNumberOfObjectives();
        double[] f = new double[numberOfObjectives];
        double[] x = new double[numberOfVariables];
        int k = this.getNumberOfVariables() - this.getNumberOfObjectives() + 1;
        for (int i2 = 0; i2 < numberOfVariables; ++i2) {
            x[i2] = (Double)solution.getVariable(i2);
        }
        double g = 0.0;
        for (int i3 = numberOfVariables - k; i3 < numberOfVariables; ++i3) {
            g += x[i3];
        }
        g = 1.0 + 9.0 * g / (double)k;
        System.arraycopy(x, 0, f, 0, numberOfObjectives - 1);
        double h = 0.0;
        for (i = 0; i < numberOfObjectives - 1; ++i) {
            h += f[i] / (1.0 + g) * (1.0 + Math.sin(Math.PI * 3 * f[i]));
        }
        h = (double)numberOfObjectives - h;
        f[numberOfObjectives - 1] = (1.0 + g) * h;
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

