/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.dtlz;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;

public class DTLZ1
extends AbstractDoubleProblem {
    public DTLZ1() {
        this(7, 3);
    }

    public DTLZ1(Integer numberOfVariables, Integer numberOfObjectives) throws JMetalException {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setName("DTLZ1");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        int i;
        int numberOfVariables = this.getNumberOfVariables();
        int numberOfObjectives = this.getNumberOfObjectives();
        double[] f = new double[numberOfObjectives];
        double[] x = new double[numberOfVariables];
        int k = this.getNumberOfVariables() - this.getNumberOfObjectives() + 1;
        for (int i2 = 0; i2 < numberOfVariables; ++i2) {
            x[i2] = (Double)solution.getVariable(i2);
        }
        double g = 0.0;
        for (i = numberOfVariables - k; i < numberOfVariables; ++i) {
            g += (x[i] - 0.5) * (x[i] - 0.5) - Math.cos(62.83185307179586 * (x[i] - 0.5));
        }
        g = 100.0 * ((double)k + g);
        for (i = 0; i < numberOfObjectives; ++i) {
            f[i] = (1.0 + g) * 0.5;
        }
        for (i = 0; i < numberOfObjectives; ++i) {
            for (int j = 0; j < numberOfObjectives - (i + 1); ++j) {
                int n = i;
                f[n] = f[n] * x[j];
            }
            if (i == 0) continue;
            int aux = numberOfObjectives - (i + 1);
            int n = i;
            f[n] = f[n] * (1.0 - x[aux]);
        }
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

