/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cdtlz;

import java.util.HashMap;
import java.util.Map;
import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ2;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class ConvexC2_DTLZ2
extends DTLZ2 {
    private static Map<Integer, Double> rValue = new HashMap<Integer, Double>();

    public ConvexC2_DTLZ2(int numberOfVariables, int numberOfObjectives) {
        super(numberOfVariables, numberOfObjectives);
        this.setNumberOfConstraints(1);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        super.evaluate(solution);
        this.evaluateConstraints(solution);
    }

    public void evaluateConstraints(DoubleSolution solution) {
        int i;
        double[] constraint = new double[this.getNumberOfConstraints()];
        double sum = 0.0;
        for (int i2 = 0; i2 < this.getNumberOfObjectives(); ++i2) {
            sum += solution.getObjective(i2);
        }
        double lambda = sum / (double)this.getNumberOfObjectives();
        sum = 0.0;
        for (i = 0; i < this.getNumberOfObjectives(); ++i) {
            sum += Math.pow(solution.getObjective(i) - lambda, 2.0);
        }
        constraint[0] = sum - Math.pow(rValue.get(this.getNumberOfObjectives()), 2.0);
        for (i = 0; i < this.getNumberOfConstraints(); ++i) {
            solution.setConstraint(i, constraint[i]);
        }
    }

    static {
        rValue.put(3, 0.225);
        rValue.put(5, 0.225);
        rValue.put(8, 0.26);
        rValue.put(10, 0.26);
        rValue.put(15, 0.27);
    }
}

