/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class Viennet2
extends AbstractDoubleProblem {
    public Viennet2() {
        this.setNumberOfVariables(2);
        this.setNumberOfObjectives(3);
        this.setNumberOfConstraints(0);
        this.setName("Viennet2");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-4.0);
            upperLimit.add(4.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        int i;
        int numberOfVariables = this.getNumberOfVariables();
        double[] f = new double[this.getNumberOfObjectives()];
        double[] x = new double[numberOfVariables];
        for (i = 0; i < numberOfVariables; ++i) {
            x[i] = (Double)solution.getVariable(i);
        }
        f[0] = (x[0] - 2.0) * (x[0] - 2.0) / 2.0 + (x[1] + 1.0) * (x[1] + 1.0) / 13.0 + 3.0;
        f[1] = (x[0] + x[1] - 3.0) * (x[0] + x[1] - 3.0) / 36.0 + (-x[0] + x[1] + 2.0) * (-x[0] + x[1] + 2.0) / 8.0 - 17.0;
        f[2] = (x[0] + 2.0 * x[1] - 1.0) * (x[0] + 2.0 * x[1] - 1.0) / 175.0 + (2.0 * x[1] - x[0]) * (2.0 * x[1] - x[0]) / 17.0 - 13.0;
        for (i = 0; i < this.getNumberOfObjectives(); ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

