/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.UF;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class UF4
extends AbstractDoubleProblem {
    public UF4() {
        this(30);
    }

    public UF4(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("UF4");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        for (int i = 1; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-2.0);
            upperLimit.add(2.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariable(i);
        }
        double sum2 = 0.0;
        double sum1 = 0.0;
        int count2 = 0;
        int count1 = 0;
        for (int j = 2; j <= this.getNumberOfVariables(); ++j) {
            double yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)this.getNumberOfVariables());
            double hj = Math.abs(yj) / (1.0 + Math.exp(2.0 * Math.abs(yj)));
            if (j % 2 == 0) {
                sum2 += hj;
                ++count2;
                continue;
            }
            sum1 += hj;
            ++count1;
        }
        solution.setObjective(0, x[0] + 2.0 * sum1 / (double)count1);
        solution.setObjective(1, 1.0 - x[0] * x[0] + 2.0 * sum2 / (double)count2);
    }
}

