/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.UF;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class UF3
extends AbstractDoubleProblem {
    public UF3() {
        this(30);
    }

    public UF3(int numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("UF3");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariable(i);
        }
        double sum2 = 0.0;
        double sum1 = 0.0;
        int count2 = 0;
        int count1 = 0;
        double prod2 = 1.0;
        double prod1 = 1.0;
        for (int j = 2; j <= this.getNumberOfVariables(); ++j) {
            double yj = x[j - 1] - Math.pow(x[0], 0.5 * (1.0 + 3.0 * ((double)j - 2.0) / ((double)this.getNumberOfVariables() - 2.0)));
            double pj = Math.cos(20.0 * yj * Math.PI / Math.sqrt(j));
            if (j % 2 == 0) {
                sum2 += yj * yj;
                prod2 *= pj;
                ++count2;
                continue;
            }
            sum1 += yj * yj;
            prod1 *= pj;
            ++count1;
        }
        solution.setObjective(0, x[0] + 2.0 * (4.0 * sum1 - 2.0 * prod1 + 2.0) / (double)count1);
        solution.setObjective(1, 1.0 - Math.sqrt(x[0]) + 2.0 * (4.0 * sum2 - 2.0 * prod2 + 2.0) / (double)count2);
    }
}

