/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class Srinivas
extends AbstractDoubleProblem {
    public Srinivas() {
        this.setNumberOfVariables(2);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(2);
        this.setName("Srinivas");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-20.0);
            upperLimit.add(20.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        double[] f = new double[solution.getNumberOfVariables()];
        double x1 = (Double)solution.getVariable(0);
        double x2 = (Double)solution.getVariable(1);
        f[0] = 2.0 + (x1 - 2.0) * (x1 - 2.0) + (x2 - 1.0) * (x2 - 1.0);
        f[1] = 9.0 * x1 - (x2 - 1.0) * (x2 - 1.0);
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
        this.evaluateConstraints(solution);
    }

    public void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double x1 = (Double)solution.getVariable(0);
        double x2 = (Double)solution.getVariable(1);
        constraint[0] = 1.0 - (x1 * x1 + x2 * x2) / 225.0;
        constraint[1] = (3.0 * x2 - x1) / 10.0 - 1.0;
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            solution.setConstraint(i, constraint[i]);
        }
    }
}

