/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class Schaffer
extends AbstractDoubleProblem {
    private static final long serialVersionUID = -2366503015218789989L;

    public Schaffer() {
        this.setNumberOfVariables(1);
        this.setNumberOfObjectives(2);
        this.setName("Schaffer");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-100000.0);
            upperLimit.add(100000.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        double[] f = new double[this.getNumberOfObjectives()];
        double value = (Double)solution.getVariable(0);
        f[0] = value * value;
        f[1] = (value - 2.0) * (value - 2.0);
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }
}

