/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.uma.jmetal.problem.AbstractGenericProblem;
import org.uma.jmetal.solution.compositesolution.CompositeSolution;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.impl.DefaultDoubleSolution;
import org.uma.jmetal.solution.integersolution.IntegerSolution;
import org.uma.jmetal.solution.integersolution.impl.DefaultIntegerSolution;

public class MixedIntegerDoubleProblem
extends AbstractGenericProblem<CompositeSolution> {
    private int valueN;
    private int valueM;
    private List<Pair<Integer, Integer>> integerBounds;
    private List<Pair<Double, Double>> doubleBounds;

    public MixedIntegerDoubleProblem() {
        this(10, 10, 100, -100, -1000, 1000);
    }

    public MixedIntegerDoubleProblem(int numberOfIntegerVariables, int numberOfDoubleVariables, int n, int m, int lowerBound, int upperBound) {
        int i;
        this.valueN = n;
        this.valueM = m;
        this.setNumberOfVariables(2);
        this.setNumberOfObjectives(2);
        this.setName("MixedIntegerDoubleProblem");
        this.integerBounds = new ArrayList<Pair<Integer, Integer>>(numberOfIntegerVariables);
        this.doubleBounds = new ArrayList<Pair<Double, Double>>(numberOfDoubleVariables);
        for (i = 0; i < numberOfIntegerVariables; ++i) {
            this.integerBounds.add((Pair<Integer, Integer>)new ImmutablePair((Object)lowerBound, (Object)upperBound));
        }
        for (i = 0; i < numberOfDoubleVariables; ++i) {
            this.doubleBounds.add((Pair<Double, Double>)new ImmutablePair((Object)lowerBound, (Object)upperBound));
        }
    }

    public void evaluate(CompositeSolution solution) {
        int approximationToN = 0;
        int approximationToM = 0;
        List integerVariables = ((IntegerSolution)solution.getVariable(0)).getVariables();
        for (int i = 0; i < integerVariables.size(); ++i) {
            approximationToN += Math.abs(this.valueN - (Integer)integerVariables.get(i));
            approximationToM += Math.abs(this.valueM - (Integer)integerVariables.get(i));
        }
        List doubleVariables = ((DoubleSolution)solution.getVariable(1)).getVariables();
        for (int i = 0; i < doubleVariables.size(); ++i) {
            approximationToN = (int)((double)approximationToN + Math.abs((double)this.valueN - (Double)doubleVariables.get(i)));
            approximationToM = (int)((double)approximationToM + Math.abs((double)this.valueM - (Double)doubleVariables.get(i)));
        }
        solution.setObjective(0, (double)approximationToN);
        solution.setObjective(1, (double)approximationToM);
    }

    public CompositeSolution createSolution() {
        DefaultIntegerSolution integerSolution = new DefaultIntegerSolution(this.integerBounds, this.getNumberOfObjectives(), this.getNumberOfConstraints());
        DefaultDoubleSolution doubleSolution = new DefaultDoubleSolution(this.doubleBounds, this.getNumberOfObjectives(), this.getNumberOfConstraints());
        return new CompositeSolution(Arrays.asList(integerSolution, doubleSolution));
    }
}

