/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class Golinski
extends AbstractDoubleProblem {
    public Golinski() {
        this.setNumberOfVariables(7);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(11);
        this.setName("Golinski");
        List<Double> lowerLimit = Arrays.asList(2.6, 0.7, 17.0, 7.3, 7.3, 2.9, 5.0);
        List<Double> upperLimit = Arrays.asList(3.6, 0.8, 28.0, 8.3, 8.3, 3.9, 5.5);
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        double x1 = (Double)solution.getVariable(0);
        double x2 = (Double)solution.getVariable(1);
        double x3 = (Double)solution.getVariable(2);
        double x4 = (Double)solution.getVariable(3);
        double x5 = (Double)solution.getVariable(4);
        double x6 = (Double)solution.getVariable(5);
        double x7 = (Double)solution.getVariable(6);
        double f1 = 0.7854 * x1 * x2 * x2 * (10.0 * x3 * x3 / 3.0 + 14.933 * x3 - 43.0934) - 1.508 * x1 * (x6 * x6 + x7 * x7) + 7.477 * (x6 * x6 * x6 + x7 * x7 * x7) + 0.7854 * (x4 * x6 * x6 + x5 * x7 * x7);
        double aux = 745.0 * x4 / (x2 * x3);
        double f2 = Math.sqrt(aux * aux + 1.69E7) / (0.1 * x6 * x6 * x6);
        solution.setObjective(0, f1);
        solution.setObjective(1, f2);
        this.evaluateConstraints(solution);
    }

    public void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double x1 = (Double)solution.getVariable(0);
        double x2 = (Double)solution.getVariable(1);
        double x3 = (Double)solution.getVariable(2);
        double x4 = (Double)solution.getVariable(3);
        double x5 = (Double)solution.getVariable(4);
        double x6 = (Double)solution.getVariable(5);
        double x7 = (Double)solution.getVariable(6);
        constraint[0] = -(1.0 / (x1 * x2 * x2 * x3) - 0.037037037037037035);
        constraint[1] = -(1.0 / (x1 * x2 * x2 * x3 * x3) - 0.0025157232704402514);
        constraint[2] = -(x4 * x4 * x4 / (x2 * x3 * x3 * x6 * x6 * x6 * x6) - 0.5181347150259068);
        constraint[3] = -(x5 * x5 * x5 / (x2 * x3 * x7 * x7 * x7 * x7) - 0.5181347150259068);
        constraint[4] = -(x2 * x3 - 40.0);
        constraint[5] = -(x1 / x2 - 12.0);
        constraint[6] = -(5.0 - x1 / x2);
        constraint[7] = -(1.9 - x4 + 1.5 * x6);
        constraint[8] = -(1.9 - x5 + 1.1 * x7);
        double aux = 745.0 * x4 / (x2 * x3);
        double f2 = Math.sqrt(aux * aux + 1.69E7) / (0.1 * x6 * x6 * x6);
        constraint[9] = -(f2 - 1300.0);
        double a = 745.0 * x5 / (x2 * x3);
        double b = 1.575E8;
        constraint[10] = -(Math.sqrt(a * a + b) / (0.1 * x7 * x7 * x7) - 1100.0);
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            solution.setConstraint(i, constraint[i]);
        }
    }
}

