/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class FourBarTruss
extends AbstractDoubleProblem {
    private double f = 10.0;
    private double e = 200000.0;
    private double l = 200.0;
    private double sigma = 10.0;

    public FourBarTruss() {
        this.setNumberOfVariables(4);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("FourBarTruss");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        lowerLimit.add(this.f / this.sigma);
        lowerLimit.add(Math.sqrt(2.0) * (this.f / this.sigma));
        lowerLimit.add((Double)lowerLimit.get(1));
        lowerLimit.add((Double)lowerLimit.get(0));
        upperLimit.add(3.0 * (this.f / this.sigma));
        upperLimit.add((Double)upperLimit.get(0));
        upperLimit.add((Double)upperLimit.get(0));
        upperLimit.add((Double)upperLimit.get(0));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        double[] fx = new double[2];
        double[] x = new double[this.getNumberOfVariables()];
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.getVariable(i);
        }
        fx[0] = this.l * (2.0 * x[0] + Math.sqrt(2.0) * x[1] + Math.sqrt(x[2]) + x[3]);
        fx[1] = this.f * this.l / this.e * (2.0 / x[0] + 2.0 * Math.sqrt(2.0) / x[1] - 2.0 * Math.sqrt(2.0) / x[2] + 2.0 / x[3]);
        solution.setObjective(0, fx[0]);
        solution.setObjective(1, fx[1]);
    }
}

