/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class ConstrEx
extends AbstractDoubleProblem {
    public ConstrEx() {
        this.setNumberOfVariables(2);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(2);
        this.setName("ConstrEx");
        List<Double> lowerLimit = Arrays.asList(0.1, 0.0);
        List<Double> upperLimit = Arrays.asList(1.0, 5.0);
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    public void evaluate(DoubleSolution solution) {
        double[] f = new double[this.getNumberOfObjectives()];
        f[0] = (Double)solution.getVariable(0);
        f[1] = (1.0 + (Double)solution.getVariable(1)) / (Double)solution.getVariable(0);
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
        this.evaluateConstraints(solution);
    }

    public void evaluateConstraints(DoubleSolution solution) {
        double x1 = (Double)solution.getVariable(0);
        double x2 = (Double)solution.getVariable(1);
        solution.setConstraint(0, x2 + 9.0 * x1 - 6.0);
        solution.setConstraint(1, -x2 + 9.0 * x1 - 1.0);
    }
}

