/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.test;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;

public abstract class AbstractContainerTest {
    protected static PauseableServer server;
    public static int port;
    protected static String BASEURI;
    protected final WebClient webClient = new WebClient();
    static String errorText;

    @BeforeClass
    public void startContainer() throws Exception {
        if (server == null) {
            String reserveNetworkPort = System.getProperty("reserved.network.port");
            if (reserveNetworkPort != null) {
                port = Integer.valueOf(reserveNetworkPort);
                BASEURI = "http://localhost:" + port + "/";
            } else {
                int maxPort = port + 10;
                while (port < maxPort) {
                    Socket sock = null;
                    try {
                        sock = new Socket("localhost", port);
                        sock.close();
                    }
                    catch (Exception e) {
                        if (sock != null) {
                            sock = null;
                        }
                        if (e.getMessage().contains("refused")) break;
                        throw new RuntimeException("Couldn't find an available port to run the functional test server", e);
                    }
                    ++port;
                }
            }
            server = new PauseableServer();
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(port);
            server.setConnectors(new Connector[]{connector});
            HandlerCollection handlers = new HandlerCollection();
            handlers.setHandlers(new Handler[]{this.buildContext(), new DefaultHandler()});
            server.setHandler((Handler)handlers);
            server.start();
            Assert.assertTrue((boolean)server.isStarted());
        }
    }

    public WebAppContext buildContext() {
        WebAppContext context = new WebAppContext("src/main/webapp", "/");
        ResourceCollection resourceCollection = new ResourceCollection(new String[]{"src/main/webapp", "src/test/webapp"});
        context.setBaseResource((Resource)resourceCollection);
        context.setParentLoaderPriority(true);
        return context;
    }

    @BeforeTest
    public void configureWebClient() {
        this.webClient.setThrowExceptionOnFailingStatusCode(true);
    }

    public void pauseServer(boolean paused) {
        if (server != null) {
            server.pause(paused);
        }
    }

    protected void assertXPathPresent(HtmlPage page, String xpath) {
        String message = "XPath not present: " + xpath;
        List list = page.getByXPath(xpath);
        if (list.isEmpty()) {
            Assert.fail((String)message);
        }
        Assert.assertNotNull(list.get(0), (String)message);
    }

    protected void assertXPathNotPresent(HtmlPage page, String xpath) {
        if (!page.getByXPath(xpath).isEmpty()) {
            Assert.fail((String)("XPath IS present: " + xpath));
        }
    }

    protected HtmlPage clickLink(HtmlPage page, String linkText) {
        try {
            return (HtmlPage)page.getAnchorByText(linkText).click();
        }
        catch (ElementNotFoundException e) {
            Assert.fail((String)("Couldn't find a link with text '" + linkText + "' on page " + page));
        }
        catch (IOException e) {
            Assert.fail((String)("Clicking on link '" + linkText + "' on page " + page + " failed because of: "), (Throwable)e);
        }
        return null;
    }

    protected HtmlPage clickButton(HtmlPage page, String buttonId) throws IOException {
        return (HtmlPage)page.getHtmlElementById(buttonId).click();
    }

    protected HtmlPage clickButton(HtmlForm form, String buttonValue) throws IOException {
        try {
            return (HtmlPage)form.getInputByValue(buttonValue).click();
        }
        catch (ElementNotFoundException e) {
            try {
                return (HtmlPage)form.getButtonByName(buttonValue).click();
            }
            catch (ElementNotFoundException e1) {
                Assert.fail((String)("Couldn't find a button with text/name '" + buttonValue + "' on form '" + form.getNameAttribute() + "'"));
                return null;
            }
        }
    }

    protected void assertErrorTextPresent(HtmlPage page) {
        WebAssert.assertTextPresent((HtmlPage)page, (String)errorText);
    }

    protected void assertErrorTextNotPresent(HtmlPage page) {
        WebAssert.assertTextNotPresent((HtmlPage)page, (String)errorText);
    }

    static {
        port = 8180;
        BASEURI = "http://localhost:" + port + "/";
        errorText = "You must correct the following errors before continuing";
    }

    public static class PauseableServer
    extends Server {
        public synchronized void pause(boolean paused) {
            try {
                if (paused) {
                    for (Connector connector : this.getConnectors()) {
                        connector.stop();
                    }
                } else {
                    for (Connector connector : this.getConnectors()) {
                        connector.start();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

