/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.util.StrategyRegistry;
import org.tynamo.descriptor.CollectionDescriptor;
import org.tynamo.descriptor.EmbeddedDescriptor;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.factories.DescriptorFactory;
import org.tynamo.exception.TynamoRuntimeException;
import org.tynamo.services.DescriptorService;

public class DescriptorServiceImpl
implements DescriptorService {
    private final StrategyRegistry<TynamoClassDescriptor> descriptorsRegistry;
    private final List<TynamoClassDescriptor> descriptors;

    public DescriptorServiceImpl(Collection<Class> types, DescriptorFactory descriptorFactory) {
        HashMap<Class, TynamoClassDescriptor> descriptorsMap = new HashMap<Class, TynamoClassDescriptor>();
        for (Class type : types) {
            try {
                TynamoClassDescriptor classDescriptor = descriptorFactory.buildClassDescriptor(type);
                descriptorsMap.put(type, classDescriptor);
            }
            catch (TynamoRuntimeException e) {}
        }
        for (Class type : types) {
            DescriptorServiceImpl.findChildren(type, descriptorsMap);
        }
        this.descriptors = CollectionFactory.newList(descriptorsMap.values());
        this.descriptorsRegistry = StrategyRegistry.newInstance(TynamoClassDescriptor.class, descriptorsMap, (boolean)true);
    }

    @Override
    public List<TynamoClassDescriptor> getAllDescriptors() {
        return this.descriptors;
    }

    @Override
    public TynamoClassDescriptor getClassDescriptor(Class type) {
        return (TynamoClassDescriptor)this.descriptorsRegistry.get(type);
    }

    private static void findChildren(Class type, Map<Class, TynamoClassDescriptor> descriptorsMap) {
        TynamoClassDescriptor classDescriptor = descriptorsMap.get(type);
        for (TynamoPropertyDescriptor propertyDescriptor : classDescriptor.getPropertyDescriptors()) {
            if (propertyDescriptor.isCollection()) {
                if (((CollectionDescriptor)propertyDescriptor).isChildRelationship()) {
                    TynamoClassDescriptor collectionClassDescriptor = descriptorsMap.get(((CollectionDescriptor)propertyDescriptor).getElementType());
                    collectionClassDescriptor.setChild(true);
                }
                if (((CollectionDescriptor)propertyDescriptor).getInverseProperty() != null) {
                    classDescriptor.setHasCyclicRelationships(true);
                }
            }
            if (!propertyDescriptor.isEmbedded() || descriptorsMap.containsKey(propertyDescriptor.getPropertyType())) continue;
            TynamoClassDescriptor tynamoClassDescriptor = ((EmbeddedDescriptor)propertyDescriptor).getEmbeddedClassDescriptor();
            descriptorsMap.put(tynamoClassDescriptor.getBeanType(), tynamoClassDescriptor);
        }
    }
}

