/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor.factories;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoClassDescriptorImpl;
import org.tynamo.descriptor.decorators.DescriptorDecorator;
import org.tynamo.descriptor.factories.DescriptorFactory;
import org.tynamo.descriptor.factories.MethodDescriptorFactory;
import org.tynamo.descriptor.factories.PropertyDescriptorFactory;
import org.tynamo.exception.TynamoRuntimeException;

public class ReflectionDescriptorFactory
implements DescriptorFactory {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionDescriptorFactory.class);
    private final MethodDescriptorFactory methodDescriptorFactory;
    private final PropertyDescriptorFactory propertyDescriptorFactory;
    private final List<DescriptorDecorator> decorators;

    public ReflectionDescriptorFactory(List<DescriptorDecorator> decorators, MethodDescriptorFactory methodDescriptorFactory, PropertyDescriptorFactory propertyDescriptorFactory) {
        this.decorators = decorators;
        this.methodDescriptorFactory = methodDescriptorFactory;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
    }

    @Override
    public TynamoClassDescriptor buildClassDescriptor(Class type) {
        try {
            TynamoClassDescriptor descriptor = new TynamoClassDescriptorImpl(type);
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            BeanUtils.copyProperties((Object)descriptor, (Object)beanInfo.getBeanDescriptor());
            descriptor.setPropertyDescriptors(this.propertyDescriptorFactory.buildPropertyDescriptors(type, beanInfo));
            descriptor.setMethodDescriptors(this.methodDescriptorFactory.buildMethodDescriptors(type, beanInfo));
            descriptor = this.applyDecorators(descriptor);
            return descriptor;
        }
        catch (IllegalAccessException e) {
            logger.error("couldn't build class descriptor for: " + type.getSimpleName(), (Throwable)e);
            throw new TynamoRuntimeException(e, type);
        }
        catch (InvocationTargetException e) {
            logger.error("couldn't build class descriptor for: " + type.getSimpleName(), (Throwable)e);
            throw new TynamoRuntimeException(e, type);
        }
        catch (IntrospectionException e) {
            logger.error("couldn't build class descriptor for: " + type.getSimpleName(), (Throwable)e);
            throw new TynamoRuntimeException(e, type);
        }
    }

    private TynamoClassDescriptor applyDecorators(TynamoClassDescriptor descriptor) {
        TynamoClassDescriptor decoratedDescriptor = descriptor;
        for (DescriptorDecorator decorator : this.decorators) {
            decoratedDescriptor = decorator.decorate(decoratedDescriptor);
        }
        return decoratedDescriptor;
    }
}

