/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Predicate;
import org.tynamo.descriptor.Descriptor;
import org.tynamo.descriptor.IMethodDescriptor;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;

public class TynamoClassDescriptorImpl
extends TynamoDescriptor
implements TynamoClassDescriptor {
    private List<TynamoPropertyDescriptor> propertyDescriptors = new ArrayList<TynamoPropertyDescriptor>();
    private List<IMethodDescriptor> methodDescriptors = new ArrayList<IMethodDescriptor>();
    private boolean child;
    boolean hasCyclicRelationships;
    boolean allowRemove = true;
    boolean allowSave = true;
    boolean searchable = false;

    public TynamoClassDescriptorImpl(TynamoClassDescriptor descriptor) {
        super(descriptor);
        this.copyPropertyDescriptorsFrom(descriptor);
        this.copyMethodDescriptorsFrom(descriptor);
    }

    public TynamoClassDescriptorImpl(Class beanType) {
        super(beanType);
    }

    public TynamoClassDescriptorImpl(TynamoClassDescriptorImpl dto) {
        super(dto);
        try {
            BeanUtils.copyProperties((Object)this, (Object)dto);
        }
        catch (IllegalAccessException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }

    private void copyMethodDescriptorsFrom(TynamoClassDescriptor descriptor) {
        for (IMethodDescriptor methodDescriptor : descriptor.getMethodDescriptors()) {
            this.getMethodDescriptors().add((IMethodDescriptor)IMethodDescriptor.class.cast(methodDescriptor.clone()));
        }
    }

    protected void copyPropertyDescriptorsFrom(TynamoClassDescriptor descriptor) {
        for (TynamoPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            this.getPropertyDescriptors().add((TynamoPropertyDescriptor)TynamoPropertyDescriptor.class.cast(propertyDescriptor.clone()));
        }
    }

    @Override
    public TynamoPropertyDescriptor getPropertyDescriptor(final String name) {
        return (TynamoPropertyDescriptor)((Flow)F.flow(this.propertyDescriptors).filter((Predicate)new Predicate<TynamoPropertyDescriptor>(){

            public boolean accept(TynamoPropertyDescriptor descriptor) {
                return descriptor.getName().equals(name);
            }
        })).first();
    }

    @Override
    public List<TynamoPropertyDescriptor> getPropertyDescriptors(List<String> properties) {
        ArrayList<TynamoPropertyDescriptor> descriptors = new ArrayList<TynamoPropertyDescriptor>();
        for (String property : properties) {
            descriptors.add(this.getPropertyDescriptor(property));
        }
        return descriptors;
    }

    @Override
    public List<IMethodDescriptor> getMethodDescriptors() {
        return this.methodDescriptors;
    }

    @Override
    public void setMethodDescriptors(List<IMethodDescriptor> methodDescriptors) {
        this.methodDescriptors = methodDescriptors;
    }

    @Override
    public List<TynamoPropertyDescriptor> getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public void setPropertyDescriptors(List<TynamoPropertyDescriptor> propertyDescriptors) {
        this.propertyDescriptors = propertyDescriptors;
    }

    @Override
    public TynamoPropertyDescriptor getIdentifierDescriptor() {
        return (TynamoPropertyDescriptor)((Flow)F.flow(this.propertyDescriptors).filter((Predicate)new Predicate<TynamoPropertyDescriptor>(){

            public boolean accept(TynamoPropertyDescriptor descriptor) {
                return descriptor.isIdentifier();
            }
        })).first();
    }

    @Override
    public boolean isChild() {
        return this.child;
    }

    @Override
    public void setChild(boolean child) {
        this.child = child;
    }

    @Override
    public Object clone() {
        return new TynamoClassDescriptorImpl(this);
    }

    @Override
    public void copyFrom(Descriptor descriptor) {
        super.copyFrom(descriptor);
        if (descriptor instanceof TynamoClassDescriptorImpl) {
            try {
                BeanUtils.copyProperties((Object)this, (Object)((TynamoClassDescriptorImpl)descriptor));
                this.copyPropertyDescriptorsFrom((TynamoClassDescriptorImpl)descriptor);
                this.copyMethodDescriptorsFrom((TynamoClassDescriptorImpl)descriptor);
            }
            catch (IllegalAccessException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error(e.toString(), (Throwable)e);
            }
        }
    }

    @Override
    public boolean isAllowRemove() {
        return this.allowRemove;
    }

    @Override
    public void setAllowRemove(boolean allowRemove) {
        this.allowRemove = allowRemove;
    }

    @Override
    public boolean isAllowSave() {
        return this.allowSave;
    }

    @Override
    public void setAllowSave(boolean allowSave) {
        this.allowSave = allowSave;
    }

    @Override
    public boolean isSearchable() {
        return this.searchable;
    }

    @Override
    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public boolean getHasCyclicRelationships() {
        return this.hasCyclicRelationships;
    }

    @Override
    public void setHasCyclicRelationships(boolean hasBidirectionalRelationship) {
        this.hasCyclicRelationships = hasBidirectionalRelationship;
    }

    public String toString() {
        return "{TynamoClassDescriptor - Type: " + this.getBeanType() + "}";
    }
}

