/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptorImpl;
import org.tynamo.descriptor.extension.CollectionExtension;

public class CollectionDescriptor
extends TynamoPropertyDescriptorImpl {
    private Class elementType;
    private boolean childRelationship = false;
    private String inverseProperty = null;
    private boolean oneToMany = false;
    private String addExpression = null;
    private String removeExpression = null;
    private String swapExpression = null;
    private boolean allowRemove = true;

    public CollectionDescriptor(Class beanType, TynamoPropertyDescriptor descriptor) {
        super(beanType, descriptor);
    }

    public CollectionDescriptor(Class beanType, CollectionDescriptor collectionDescriptor) {
        super(beanType, collectionDescriptor.getBeanType());
        this.copyFrom(collectionDescriptor);
    }

    public CollectionDescriptor(Class beanType, String name, Class type) {
        super(beanType, type);
        this.setName(name);
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    public Class getElementType() {
        return this.elementType;
    }

    public void setElementType(Class elementType) {
        this.elementType = elementType;
    }

    public String getInverseProperty() {
        return this.supportsCollectionExtension() && this.getCollectionExtension().getInverseProperty() != null ? this.getCollectionExtension().getInverseProperty() : this.inverseProperty;
    }

    public void setInverseProperty(String inverseProperty) {
        this.inverseProperty = inverseProperty;
    }

    public boolean isOneToMany() {
        return this.oneToMany;
    }

    public void setOneToMany(boolean oneToMany) {
        this.oneToMany = oneToMany;
    }

    public boolean isChildRelationship() {
        return this.supportsCollectionExtension() ? this.getCollectionExtension().isChildRelationship() : this.childRelationship;
    }

    public void setChildRelationship(boolean childRelationship) {
        this.childRelationship = childRelationship;
        if (this.childRelationship) {
            this.setSearchable(false);
        }
    }

    public String getAddExpression() {
        return this.supportsCollectionExtension() && this.getCollectionExtension().getAddExpression() != null ? this.getCollectionExtension().getAddExpression() : this.addExpression;
    }

    public void setAddExpression(String addExpression) {
        this.addExpression = addExpression;
    }

    public String getRemoveExpression() {
        return this.supportsCollectionExtension() && this.getCollectionExtension().getRemoveExpression() != null ? this.getCollectionExtension().getRemoveExpression() : this.removeExpression;
    }

    public void setRemoveExpression(String removeExpression) {
        this.removeExpression = removeExpression;
    }

    public String getSwapExpression() {
        return this.supportsCollectionExtension() && this.getCollectionExtension().getSwapExpression() != null ? this.getCollectionExtension().getSwapExpression() : this.swapExpression;
    }

    public void setSwapExpression(String swapExpression) {
        this.swapExpression = swapExpression;
    }

    public boolean isAllowRemove() {
        return this.supportsCollectionExtension() ? this.getCollectionExtension().isAllowRemove() : this.allowRemove;
    }

    private CollectionExtension getCollectionExtension() {
        return this.getExtension(CollectionExtension.class);
    }

    private boolean supportsCollectionExtension() {
        return this.supportsExtension(CollectionExtension.class);
    }

    public void setAllowRemove(boolean allowRemove) {
        this.allowRemove = allowRemove;
    }

    @Override
    public Object clone() {
        return new CollectionDescriptor(this.getBeanType(), this);
    }

    private void copyFrom(CollectionDescriptor collectionDescriptor) {
        LOGGER.debug("Cloning CollectionDescriptor");
        try {
            BeanUtils.copyProperties((Object)this, (Object)collectionDescriptor);
        }
        catch (IllegalAccessException e) {
            LOGGER.error(e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOGGER.error(e.getMessage());
        }
    }
}

