/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.blob;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.tynamo.blob.BlobManager;
import org.tynamo.builder.BuilderDirector;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.extension.BlobDescriptorExtension;
import org.tynamo.descriptor.extension.TynamoBlob;
import org.tynamo.services.PersistenceService;

public class BlobManagerImpl
implements BlobManager {
    private PersistenceService persistenceService;
    private PropertyAccess propertyAccess;
    private PageRenderLinkSource pageRenderLinkSource;
    private BuilderDirector builderDirector;

    public BlobManagerImpl(PersistenceService persistenceService, PropertyAccess propertyAccess, PageRenderLinkSource pageRenderLinkSource, BuilderDirector builderDirector) {
        this.persistenceService = persistenceService;
        this.propertyAccess = propertyAccess;
        this.pageRenderLinkSource = pageRenderLinkSource;
        this.builderDirector = builderDirector;
    }

    @Override
    public void store(TynamoPropertyDescriptor propertyDescriptor, Object model, UploadedFile file) {
        BlobDescriptorExtension blobDescriptorExtension = this.getBlobDescriptorExtension(propertyDescriptor);
        byte[] data = new byte[]{};
        InputStream inputStream = file.getStream();
        try {
            data = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (data.length > 1) {
            if (blobDescriptorExtension.isBytes()) {
                this.propertyAccess.set(model, propertyDescriptor.getName(), (Object)data);
            } else if (blobDescriptorExtension.isITynamoBlob()) {
                TynamoBlob tynamoBlob = (TynamoBlob)this.propertyAccess.get(model, propertyDescriptor.getName());
                if (tynamoBlob == null) {
                    tynamoBlob = (TynamoBlob)this.builderDirector.createNewInstance(propertyDescriptor.getPropertyType());
                    this.propertyAccess.set(model, propertyDescriptor.getName(), (Object)tynamoBlob);
                }
                tynamoBlob.setFileName(file.getFileName());
                tynamoBlob.setFilePath(file.getFilePath());
                tynamoBlob.setContentType(file.getContentType());
                tynamoBlob.setBytes(data);
            }
        }
    }

    @Override
    public byte[] getData(TynamoPropertyDescriptor propertyDescriptor, Object model) {
        BlobDescriptorExtension blobDescriptorExtension = this.getBlobDescriptorExtension(propertyDescriptor);
        if (blobDescriptorExtension.isBytes()) {
            return (byte[])this.propertyAccess.get(model, propertyDescriptor.getName());
        }
        if (blobDescriptorExtension.isITynamoBlob()) {
            TynamoBlob tynamoBlob = (TynamoBlob)this.propertyAccess.get(model, propertyDescriptor.getName());
            return tynamoBlob != null ? tynamoBlob.getBytes() : new byte[]{};
        }
        return null;
    }

    @Override
    public void delete(TynamoPropertyDescriptor propertyDescriptor, Object model) {
        BlobDescriptorExtension blobDescriptorExtension = this.getBlobDescriptorExtension(propertyDescriptor);
        if (blobDescriptorExtension.isBytes()) {
            this.propertyAccess.set(model, propertyDescriptor.getName(), (Object)new byte[0]);
        } else if (blobDescriptorExtension.isITynamoBlob()) {
            TynamoBlob tynamoBlob = (TynamoBlob)this.propertyAccess.get(model, propertyDescriptor.getName());
            tynamoBlob.reset();
        }
        this.persistenceService.save(model);
    }

    @Override
    public Link createBlobLink(TynamoPropertyDescriptor propertyDescriptor, Object model) {
        return this.pageRenderLinkSource.createPageRenderLinkWithContext("tynamo/Blob", new Object[]{propertyDescriptor.getBeanType(), model, propertyDescriptor.getName()});
    }

    @Override
    public String getContentType(TynamoPropertyDescriptor propertyDescriptor, Object model) {
        TynamoBlob tynamoBlob;
        BlobDescriptorExtension blobDescriptorExtension = this.getBlobDescriptorExtension(propertyDescriptor);
        if (blobDescriptorExtension.isITynamoBlob() && (tynamoBlob = (TynamoBlob)this.propertyAccess.get(model, propertyDescriptor.getName())) != null) {
            return tynamoBlob.getContentType();
        }
        return blobDescriptorExtension.getContentType();
    }

    @Override
    public String getFileName(TynamoPropertyDescriptor propertyDescriptor, Object model) {
        TynamoBlob tynamoBlob;
        BlobDescriptorExtension blobDescriptorExtension = this.getBlobDescriptorExtension(propertyDescriptor);
        if (StringUtils.isNotEmpty((String)blobDescriptorExtension.getFileName())) {
            return blobDescriptorExtension.getFileName();
        }
        if (blobDescriptorExtension.isITynamoBlob() && (tynamoBlob = (TynamoBlob)this.propertyAccess.get(model, propertyDescriptor.getName())) != null) {
            return tynamoBlob.getFileName();
        }
        return null;
    }

    @Override
    public boolean isNotNull(TynamoPropertyDescriptor propertyDescriptor, Object model) {
        if (model != null) {
            BlobDescriptorExtension blobDescriptorExtension = this.getBlobDescriptorExtension(propertyDescriptor);
            byte[] bytes = null;
            if (blobDescriptorExtension.isITynamoBlob()) {
                TynamoBlob tynamoBlob = (TynamoBlob)this.propertyAccess.get(model, propertyDescriptor.getName());
                bytes = tynamoBlob != null ? tynamoBlob.getBytes() : null;
            } else if (blobDescriptorExtension.isBytes()) {
                bytes = (byte[])this.propertyAccess.get(model, propertyDescriptor.getName());
            }
            return bytes != null && bytes.length > 0;
        }
        return false;
    }

    private BlobDescriptorExtension getBlobDescriptorExtension(TynamoPropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getExtension(BlobDescriptorExtension.class);
    }
}

