/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.tynamo.components.SearchFilters;
import org.tynamo.descriptor.CollectionDescriptor;
import org.tynamo.descriptor.EmbeddedDescriptor;
import org.tynamo.descriptor.ObjectReferenceDescriptor;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.extension.BeanModelExtension;
import org.tynamo.search.SearchFilterOperator;
import org.tynamo.search.SearchFilterPredicate;
import org.tynamo.services.DescriptorService;
import org.tynamo.services.SearchableGridDataSourceProvider;
import org.tynamo.util.DisplayNameUtils;

public abstract class GenericModelSearch {
    @Inject
    private DescriptorService descriptorService;
    @Inject
    SearchableGridDataSourceProvider gridDataSourceProvider;
    @Inject
    private Messages messages;
    @InjectComponent
    private SearchFilters searchFilters;
    @Parameter(required=true, allowNull=false)
    private Class beanType;
    @Persist
    private String searchTerms;
    @Persist
    private Map<Class, SortedMap<TynamoPropertyDescriptor, SearchFilterPredicate>> filterStateByBeanType;
    @Property(write=false)
    private SortedMap<TynamoPropertyDescriptor, SearchFilterPredicate> displayableFilterDescriptorMap;
    private List<TynamoPropertyDescriptor> searchablePropertyDescriptors;
    private GridDataSource gridDataSource;

    public Class getBeanType() {
        return this.beanType;
    }

    public SearchableGridDataSourceProvider getGridDataSourceProvider() {
        return this.gridDataSourceProvider;
    }

    void setupRender() {
        this.doPrepare();
    }

    void onPrepareForSubmitFromSearchFilterForm() {
        this.doPrepare();
    }

    protected void doPrepare() {
        if (this.displayableFilterDescriptorMap != null && this.searchablePropertyDescriptors != null) {
            return;
        }
        TynamoClassDescriptor classDescriptor = this.descriptorService.getClassDescriptor(this.beanType);
        if (this.filterStateByBeanType == null) {
            this.filterStateByBeanType = Collections.synchronizedMap(new HashMap());
        } else {
            this.displayableFilterDescriptorMap = this.filterStateByBeanType.get(this.beanType);
        }
        if (this.displayableFilterDescriptorMap == null || this.searchablePropertyDescriptors == null) {
            TreeMap<TynamoPropertyDescriptor, SearchFilterPredicate> map = new TreeMap<TynamoPropertyDescriptor, SearchFilterPredicate>(new TynamoPropertyDescriptorComparator());
            ArrayList<TynamoPropertyDescriptor> descriptors = new ArrayList<TynamoPropertyDescriptor>();
            for (TynamoPropertyDescriptor descriptor : classDescriptor.getPropertyDescriptors()) {
                if (descriptor.isNonVisual() || descriptor.isIdentifier() || !descriptor.isSearchable()) continue;
                if (this.isUsedAsSearchFilter(classDescriptor, descriptor)) {
                    if (descriptor instanceof ObjectReferenceDescriptor || descriptor instanceof CollectionDescriptor || descriptor instanceof EmbeddedDescriptor || descriptor.supportsExtension(BeanModelExtension.class)) continue;
                    map.put(descriptor, this.createSearchFilterPredicate(descriptor.getPropertyType()));
                    continue;
                }
                descriptors.add(descriptor);
            }
            if (this.displayableFilterDescriptorMap == null) {
                this.filterStateByBeanType.put(this.beanType, map);
                this.displayableFilterDescriptorMap = map;
            }
            this.searchablePropertyDescriptors = descriptors;
        }
    }

    protected SearchFilterPredicate createSearchFilterPredicate(Class propertyType) {
        SearchFilterPredicate predicate = new SearchFilterPredicate();
        predicate.setOperator(SearchFilterOperator.eq);
        if (Boolean.TYPE.isAssignableFrom(propertyType)) {
            predicate.setLowValue(Boolean.FALSE);
        } else if (Boolean.class.isAssignableFrom(propertyType)) {
            predicate.setLowValue(Boolean.FALSE);
        } else if (String.class.isAssignableFrom(propertyType)) {
            predicate.setOperator(SearchFilterOperator.contains);
        }
        return predicate;
    }

    public boolean isSearchable() {
        boolean searchable = this.descriptorService.getClassDescriptor(this.beanType).isSearchable();
        if (!searchable) {
            return false;
        }
        return this.isSearchCriteriaSet() || this.getGridDataSource().getAvailableRows() > 0;
    }

    public boolean isSearchFiltersAvailable() {
        return this.displayableFilterDescriptorMap != null && this.displayableFilterDescriptorMap.size() > 0;
    }

    public boolean isSearchCriteriaSet() {
        return this.getSearchTerms() != null || this.getActiveFilterMap().size() > 0;
    }

    public void resetSearchCriteria() {
        this.setSearchTerms(null);
        this.filterStateByBeanType.put(this.beanType, null);
    }

    public boolean isUsedAsSearchFilter(TynamoClassDescriptor classDescriptor, TynamoPropertyDescriptor propertyDescriptor) {
        return !propertyDescriptor.isString();
    }

    public Map<TynamoPropertyDescriptor, SearchFilterPredicate> getActiveFilterMap() {
        if (this.filterStateByBeanType == null) {
            return Collections.emptyMap();
        }
        SortedMap<TynamoPropertyDescriptor, SearchFilterPredicate> descriptorMap = this.filterStateByBeanType.get(this.beanType);
        if (descriptorMap == null) {
            return Collections.emptyMap();
        }
        HashMap<TynamoPropertyDescriptor, SearchFilterPredicate> activeDescriptorMap = new HashMap<TynamoPropertyDescriptor, SearchFilterPredicate>();
        for (Map.Entry<TynamoPropertyDescriptor, SearchFilterPredicate> entry : descriptorMap.entrySet()) {
            if (!entry.getValue().isEnabled()) continue;
            activeDescriptorMap.put(entry.getKey(), entry.getValue());
        }
        return activeDescriptorMap;
    }

    public final GridDataSource getGridDataSource() {
        this.doPrepare();
        if (this.gridDataSource == null) {
            this.gridDataSource = this.createGridDataSource();
        }
        return this.gridDataSource;
    }

    protected GridDataSource createGridDataSource() {
        if (this.searchTerms != null) {
            return this.gridDataSourceProvider.createGridDataSource(this.beanType, this.getActiveFilterMap(), this.searchablePropertyDescriptors, this.searchTerms);
        }
        return this.gridDataSourceProvider.createGridDataSource(this.beanType, null, this.getActiveFilterMap());
    }

    public String getSearchTerms() {
        return this.searchTerms;
    }

    public void setSearchTerms(String searchTerms) {
        this.searchTerms = searchTerms;
    }

    private class TynamoPropertyDescriptorComparator
    implements Comparator<TynamoPropertyDescriptor> {
        private TynamoPropertyDescriptorComparator() {
        }

        @Override
        public int compare(TynamoPropertyDescriptor o1, TynamoPropertyDescriptor o2) {
            return DisplayNameUtils.getDisplayName(o1, GenericModelSearch.this.messages).compareTo(DisplayNameUtils.getDisplayName(o2, GenericModelSearch.this.messages));
        }
    }
}

