/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4;

import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.messageresolver.StandardMessageResolver;
import org.thymeleaf.spring4.dialect.SpringStandardDialect;
import org.thymeleaf.spring4.messageresolver.SpringMessageResolver;

public class SpringTemplateEngine
extends TemplateEngine
implements MessageSourceAware,
InitializingBean {
    private static final SpringStandardDialect SPRINGSTANDARD_DIALECT = new SpringStandardDialect();
    private MessageSource messageSource = null;
    private MessageSource templateEngineMessageSource = null;

    public SpringTemplateEngine() {
        super.setDialect((IDialect)SPRINGSTANDARD_DIALECT);
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setTemplateEngineMessageSource(MessageSource templateEngineMessageSource) {
        this.templateEngineMessageSource = templateEngineMessageSource;
    }

    public boolean getEnableSpringELCompiler() {
        Set dialects = this.getDialects();
        for (IDialect dialect : dialects) {
            if (!(dialect instanceof SpringStandardDialect)) continue;
            return ((SpringStandardDialect)dialect).getEnableSpringELCompiler();
        }
        return false;
    }

    public void setEnableSpringELCompiler(boolean enableSpringELCompiler) {
        Set dialects = this.getDialects();
        for (IDialect dialect : dialects) {
            if (!(dialect instanceof SpringStandardDialect)) continue;
            ((SpringStandardDialect)dialect).setEnableSpringELCompiler(enableSpringELCompiler);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Object messageResolver;
        MessageSource messageSource;
        MessageSource messageSource2 = messageSource = this.templateEngineMessageSource == null ? this.messageSource : this.templateEngineMessageSource;
        if (messageSource != null) {
            SpringMessageResolver springMessageResolver = new SpringMessageResolver();
            springMessageResolver.setMessageSource(messageSource);
            messageResolver = springMessageResolver;
        } else {
            messageResolver = new StandardMessageResolver();
        }
        super.setMessageResolver((IMessageResolver)messageResolver);
    }
}

