/*
 * Decompiled with CFR 0.152.
 */
package org.tio.common.starter.configuration;

import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.springframework.beans.BeanUtils;

public class TioRedisClusterProperties {
    private final String SENTINEL = "sentinel";
    private final String CLUSTER = "cluster";
    private String mode;
    private ClusterServersConfig cluster;
    private SentinelServersConfig sentinel;
    private String clientBeanName;
    private String configPath;
    private String ip = "127.0.0.1";
    private Integer port = 6379;
    private String password;
    private Integer poolSize = 32;
    private Integer minimumIdleSize = 16;

    public String getClientBeanName() {
        return this.clientBeanName;
    }

    public void setClientBeanName(String clientBeanName) {
        this.clientBeanName = clientBeanName;
    }

    public boolean useInjectRedissonClient() {
        return this.clientBeanName != null && !this.clientBeanName.isEmpty();
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean useConfigParameter() {
        return "cluster".equals(this.mode) || "sentinel".equals(this.mode);
    }

    public Config getClusterOrSentinelConfig() {
        Config config = new Config();
        if ("cluster".equals(this.mode)) {
            ClusterServersConfig clusterServersConfig = config.useClusterServers();
            BeanUtils.copyProperties((Object)this.cluster, (Object)clusterServersConfig, ClusterServersConfig.class);
            this.cluster.getNodeAddresses().parallelStream().forEach(node -> clusterServersConfig.addNodeAddress(new String[]{node.toString()}));
        } else if ("sentinel".equals(this.mode)) {
            SentinelServersConfig sentinelServersConfig = config.useSentinelServers();
            BeanUtils.copyProperties((Object)this.sentinel, (Object)sentinelServersConfig, SentinelServersConfig.class);
            this.sentinel.getSentinelAddresses().parallelStream().forEach(node -> sentinelServersConfig.addSentinelAddress(new String[]{node.toString()}));
        }
        return config;
    }

    public void setCluster(ClusterServersConfig cluster) {
        this.cluster = cluster;
    }

    public void setSentinel(SentinelServersConfig sentinel) {
        this.sentinel = sentinel;
    }

    public boolean useConfigFile() {
        return this.configPath != null && !this.configPath.isEmpty();
    }

    public boolean isYAMLConfig() {
        if (this.useConfigFile()) {
            return this.configPath.toLowerCase().endsWith("yaml");
        }
        return false;
    }

    public boolean isJSONConfig() {
        if (this.useConfigFile()) {
            return this.configPath.toLowerCase().endsWith("json");
        }
        return false;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public boolean hasPassword() {
        return this.getPassword() != null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(Integer poolSize) {
        this.poolSize = poolSize;
    }

    public Integer getMinimumIdleSize() {
        return this.minimumIdleSize;
    }

    public void setMinimumIdleSize(Integer minimumIdleSize) {
        this.minimumIdleSize = minimumIdleSize;
    }

    public String toString() {
        return "redis://" + this.getIp() + ":" + this.getPort();
    }
}

