/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.Tio;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpRequestDecoder;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseEncoder;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.server.intf.ServerAioHandler;

public class HttpServerAioHandler
implements ServerAioHandler {
    private static Logger log = LoggerFactory.getLogger(HttpServerAioHandler.class);
    public static final String REQUEST_KEY = "tio_request_key";
    protected HttpConfig httpConfig;
    private HttpRequestHandler requestHandler;

    public HttpServerAioHandler(HttpConfig httpConfig, HttpRequestHandler requestHandler) {
        this.httpConfig = httpConfig;
        this.requestHandler = requestHandler;
    }

    public HttpRequest decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws AioDecodeException {
        HttpRequest request = HttpRequestDecoder.decode((ByteBuffer)buffer, (int)limit, (int)position, (int)readableLength, (ChannelContext)channelContext, (HttpConfig)this.httpConfig);
        if (request != null) {
            channelContext.setAttribute(REQUEST_KEY, (Object)request);
        }
        return request;
    }

    public ByteBuffer encode(Packet packet, GroupContext groupContext, ChannelContext channelContext) {
        HttpResponse httpResponse = (HttpResponse)packet;
        try {
            ByteBuffer byteBuffer = HttpResponseEncoder.encode((HttpResponse)httpResponse, (GroupContext)groupContext, (ChannelContext)channelContext);
            return byteBuffer;
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void handler(Packet packet, ChannelContext channelContext) throws Exception {
        HttpRequest request = (HttpRequest)packet;
        String ip = request.getClientIp();
        if (channelContext.groupContext.ipBlacklist.isInBlacklist(ip)) {
            HttpResponse httpResponse = request.httpConfig.getRespForBlackIp();
            if (httpResponse != null) {
                Tio.send((ChannelContext)channelContext, (Packet)httpResponse);
                return;
            }
            Tio.remove((ChannelContext)channelContext, (String)(ip + "\u5728\u9ed1\u540d\u5355\u4e2d"));
            return;
        }
        HttpResponse httpResponse = this.requestHandler.handler(request);
        if (httpResponse != null) {
            Tio.send((ChannelContext)channelContext, (Packet)httpResponse);
        } else {
            if (log.isInfoEnabled()) {
                log.info("{}, {}, handler return null, request line: {}", new Object[]{channelContext.groupContext.getName(), channelContext.toString(), request.getRequestLine().toString()});
            }
            request.close("handler return null");
        }
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }
}

