/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.udp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Node;
import org.tio.core.udp.UdpPacket;
import org.tio.core.udp.UdpServerConf;
import org.tio.core.udp.intf.UdpHandler;
import org.tio.core.udp.task.UdpHandlerRunnable;
import org.tio.core.udp.task.UdpSendRunnable;
import org.tio.utils.hutool.StrUtil;

public class UdpServer {
    private static Logger log = LoggerFactory.getLogger(UdpServer.class);
    private LinkedBlockingQueue<UdpPacket> handlerQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<DatagramPacket> sendQueue = new LinkedBlockingQueue();
    private DatagramSocket datagramSocket = null;
    private byte[] readBuf = null;
    private volatile boolean isStopped = false;
    private UdpHandlerRunnable udpHandlerRunnable;
    private UdpSendRunnable udpSendRunnable = null;
    private UdpServerConf udpServerConf;

    public static void main(String[] args) throws IOException {
        final AtomicLong count = new AtomicLong();
        UdpServer udpServer = null;
        UdpHandler udpHandler = new UdpHandler(){

            @Override
            public void handler(UdpPacket udpPacket, DatagramSocket datagramSocket) {
                String str;
                byte[] data = udpPacket.getData();
                String msg = new String(data);
                Node remote = udpPacket.getRemote();
                long c = count.incrementAndGet();
                if (c % 10000L == 0L) {
                    str = "\u3010" + msg + "\u3011 from " + remote;
                    log.error(str);
                }
                str = "\u3010" + msg + "\u3011 from " + remote;
                log.error(str);
                int otherPartyPort = 8000;
                DatagramPacket datagramPacket = new DatagramPacket(data, data.length, new InetSocketAddress(remote.getIp(), otherPartyPort));
                try {
                    datagramSocket.send(datagramPacket);
                }
                catch (Throwable e) {
                    log.error(e.toString(), e);
                }
            }
        };
        UdpServerConf udpServerConf = new UdpServerConf(3000, udpHandler, 5000);
        udpServer = new UdpServer(udpServerConf);
        udpServer.start();
    }

    public UdpServer(UdpServerConf udpServerConf) throws SocketException {
        this.udpServerConf = udpServerConf;
        this.datagramSocket = new DatagramSocket(this.udpServerConf.getServerNode().getPort());
        this.readBuf = new byte[this.udpServerConf.getReadBufferSize()];
        this.udpHandlerRunnable = new UdpHandlerRunnable(udpServerConf.getUdpHandler(), this.handlerQueue, this.datagramSocket);
        this.udpSendRunnable = new UdpSendRunnable(this.sendQueue, udpServerConf, this.datagramSocket);
    }

    public void send(byte[] data, Node remoteNode) {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(remoteNode.getIp(), remoteNode.getPort());
        DatagramPacket datagramPacket = new DatagramPacket(data, data.length, inetSocketAddress);
        this.sendQueue.add(datagramPacket);
    }

    public void send(String str, Node remoteNode) {
        this.send(str, null, remoteNode);
    }

    public void send(String data, String charset, Node remoteNode) {
        if (StrUtil.isBlank((CharSequence)data)) {
            return;
        }
        try {
            if (StrUtil.isBlank((CharSequence)charset)) {
                charset = this.udpServerConf.getCharset();
            }
            byte[] bs = data.getBytes(charset);
            this.send(bs, remoteNode);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public void start() {
        this.startListen();
        this.startHandler();
        this.startSend();
    }

    private void startHandler() {
        Thread thread = new Thread((Runnable)this.udpHandlerRunnable, "tio-udp-server-handler");
        thread.setDaemon(false);
        thread.start();
    }

    private void startListen() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String startLog = "started tio udp server: " + UdpServer.this.udpServerConf.getServerNode();
                if (log.isInfoEnabled()) {
                    log.info(startLog);
                } else {
                    System.out.println(startLog);
                }
                while (!UdpServer.this.isStopped) {
                    try {
                        DatagramPacket datagramPacket = new DatagramPacket(UdpServer.this.readBuf, UdpServer.this.readBuf.length);
                        UdpServer.this.datagramSocket.receive(datagramPacket);
                        byte[] data = new byte[datagramPacket.getLength()];
                        System.arraycopy(UdpServer.this.readBuf, 0, data, 0, datagramPacket.getLength());
                        String remoteip = datagramPacket.getAddress().getHostAddress();
                        int remoteport = datagramPacket.getPort();
                        Node remote = new Node(remoteip, remoteport);
                        UdpPacket udpPacket = new UdpPacket(data, remote);
                        UdpServer.this.handlerQueue.put(udpPacket);
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
            }
        };
        Thread thread = new Thread(runnable, "tio-udp-server-listen");
        thread.setDaemon(false);
        thread.start();
    }

    private void startSend() {
        Thread thread = new Thread((Runnable)this.udpSendRunnable, "tio-udp-client-send");
        thread.setDaemon(false);
        thread.start();
    }

    public void stop() {
        this.isStopped = true;
        this.datagramSocket.close();
        this.udpHandlerRunnable.stop();
    }
}

