/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.starter;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.cluster.TioClusterConfig;
import org.tio.cluster.TioClusterTopic;
import org.tio.cluster.redisson.RedissonTioClusterTopic;
import org.tio.common.starter.TioServerMsgHandlerNotFoundException;
import org.tio.core.intf.GroupListener;
import org.tio.core.starter.configuration.TioServerClusterProperties;
import org.tio.core.starter.configuration.TioServerProperties;
import org.tio.core.starter.configuration.TioServerSslProperties;
import org.tio.core.stat.IpStatListener;
import org.tio.server.ServerTioConfig;
import org.tio.server.TioServer;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;

public final class TioServerBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(TioServerBootstrap.class);
    private static final String GROUP_CONTEXT_NAME = "tio-server-spring-boot-starter";
    private TioServerProperties serverProperties;
    private TioServerClusterProperties clusterProperties;
    private TioServerSslProperties serverSslProperties;
    private RedissonTioClusterTopic redissonTioClusterTopic;
    private TioClusterConfig clusterConfig;
    private TioServer tioServer;
    private ServerTioConfig serverTioConfig;
    private ServerAioHandler serverAioHandler;
    private IpStatListener ipStatListener;
    private GroupListener groupListener;
    private ServerAioListener serverAioListener;

    public TioServerBootstrap(TioServerProperties serverProperties, TioServerClusterProperties clusterProperties, TioServerSslProperties serverSslProperties, RedissonTioClusterTopic redissonTioClusterTopic, IpStatListener ipStatListener, GroupListener groupListener, ServerAioHandler serverAioHandler, ServerAioListener serverAioListener) {
        this.serverProperties = serverProperties;
        this.clusterProperties = clusterProperties;
        this.serverSslProperties = serverSslProperties;
        logger.debug(serverSslProperties.toString());
        if (redissonTioClusterTopic == null) {
            logger.info("cluster mod closed");
        }
        this.redissonTioClusterTopic = redissonTioClusterTopic;
        this.ipStatListener = ipStatListener;
        this.groupListener = groupListener;
        this.serverAioListener = serverAioListener;
        this.serverAioHandler = serverAioHandler;
        this.afterSetProperties();
    }

    private void afterSetProperties() {
        if (this.serverAioHandler == null) {
            throw new TioServerMsgHandlerNotFoundException();
        }
        if (this.ipStatListener == null) {
            logger.warn("no bean type of IpStatListener found");
        }
        if (this.groupListener == null) {
            logger.warn("no bean type of GroupListener found");
        }
    }

    public ServerTioConfig getServerTioConfig() {
        return this.serverTioConfig;
    }

    public void contextInitialized() {
        logger.info("initialize tio websocket server");
        try {
            this.initTioServerConfig();
            this.initTioServerTioConfig();
            this.initTioServer();
            this.start();
        }
        catch (Throwable e) {
            logger.error("Cannot bootstrap tio server :", e);
            throw new RuntimeException("Cannot bootstrap tio server :", e);
        }
    }

    private void initTioServerConfig() {
        if (this.redissonTioClusterTopic != null && this.clusterProperties.isEnabled()) {
            this.clusterConfig = new TioClusterConfig((TioClusterTopic)this.redissonTioClusterTopic);
            this.clusterConfig.setCluster4all(this.clusterProperties.isAll());
            this.clusterConfig.setCluster4bsId(true);
            this.clusterConfig.setCluster4channelId(this.clusterProperties.isChannel());
            this.clusterConfig.setCluster4group(this.clusterProperties.isGroup());
            this.clusterConfig.setCluster4ip(this.clusterProperties.isIp());
            this.clusterConfig.setCluster4user(this.clusterProperties.isUser());
        }
    }

    private void initTioServer() {
        this.tioServer = new TioServer(this.serverTioConfig);
    }

    private void initTioServerTioConfig() {
        this.serverTioConfig = new ServerTioConfig(GROUP_CONTEXT_NAME, this.serverAioHandler, this.serverAioListener);
        if (this.ipStatListener != null) {
            this.serverTioConfig.setIpStatListener(this.ipStatListener);
            this.serverTioConfig.ipStats.addDurations(this.serverProperties.getIpStatDurations());
        }
        if (this.serverAioListener != null) {
            this.serverTioConfig.setServerAioListener(this.serverAioListener);
        }
        if (this.groupListener != null) {
            this.serverTioConfig.setGroupListener(this.groupListener);
        }
        if (this.serverProperties.getHeartbeatTimeout() > 0) {
            this.serverTioConfig.setHeartbeatTimeout((long)this.serverProperties.getHeartbeatTimeout());
        }
        if (this.clusterConfig != null) {
            this.serverTioConfig.setTioClusterConfig(this.clusterConfig);
        }
        if (this.serverSslProperties.isEnabled()) {
            try {
                this.serverTioConfig.useSsl(this.serverSslProperties.getKeyStore(), this.serverSslProperties.getTrustStore(), this.serverSslProperties.getPassword());
            }
            catch (Exception e) {
                logger.error("init ssl config error", (Throwable)e);
            }
        }
    }

    private void start() throws IOException {
        this.tioServer.start(this.serverProperties.getIp(), this.serverProperties.getPort());
    }
}

