/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.starter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.tio.cluster.redisson.RedissonTioClusterTopic;
import org.tio.common.starter.RedisInitializer;
import org.tio.common.starter.configuration.TioRedisClusterProperties;
import org.tio.core.intf.GroupListener;
import org.tio.core.starter.TioServerBootstrap;
import org.tio.core.starter.TioServerInitializerConfiguration;
import org.tio.core.starter.TioServerMarkerConfiguration;
import org.tio.core.starter.configuration.TioServerClusterProperties;
import org.tio.core.starter.configuration.TioServerProperties;
import org.tio.core.starter.configuration.TioServerRedisClusterProperties;
import org.tio.core.starter.configuration.TioServerSslProperties;
import org.tio.core.stat.IpStatListener;
import org.tio.server.ServerTioConfig;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;

@Configuration
@Import(value={TioServerInitializerConfiguration.class})
@ConditionalOnBean(value={TioServerMarkerConfiguration.Marker.class})
@EnableConfigurationProperties(value={TioServerProperties.class, TioServerClusterProperties.class, TioServerRedisClusterProperties.class, TioServerSslProperties.class})
public class TioServerAutoConfiguration {
    private static final String CLUSTER_TOPIC_CHANNEL = "tio_server_spring_boot_starter";
    @Autowired(required=false)
    private ServerAioHandler serverAioHandler;
    @Autowired(required=false)
    private IpStatListener ipStatListener;
    @Autowired(required=false)
    private GroupListener groupListener;
    @Autowired(required=false)
    private ServerAioListener serverAioListener;
    @Autowired
    private TioServerClusterProperties clusterProperties;
    @Autowired
    private TioServerRedisClusterProperties redisConfig;
    @Autowired
    private TioServerProperties serverProperties;
    @Autowired
    private TioServerSslProperties serverSslProperties;
    @Autowired(required=false)
    private RedissonTioClusterTopic redissonTioClusterTopic;
    private static TioServerBootstrap tioServerBootstrap;

    @Bean
    public TioServerBootstrap webSocketServerBootstrap() {
        if (tioServerBootstrap == null) {
            tioServerBootstrap = new TioServerBootstrap(this.serverProperties, this.clusterProperties, this.serverSslProperties, this.redissonTioClusterTopic, this.ipStatListener, this.groupListener, this.serverAioHandler, this.serverAioListener);
        }
        return tioServerBootstrap;
    }

    @Bean
    public ServerTioConfig serverTioConfig(TioServerBootstrap bootstrap) {
        return bootstrap.getServerTioConfig();
    }

    @Bean
    @ConditionalOnProperty(value={"tio.core.cluster.enabled"}, havingValue="true", matchIfMissing=true)
    public RedisInitializer redisInitializer(ApplicationContext applicationContext) {
        return new RedisInitializer((TioRedisClusterProperties)this.redisConfig, applicationContext);
    }

    @Bean
    @ConditionalOnBean(value={RedisInitializer.class})
    public RedissonTioClusterTopic redissonTioClusterTopic(RedisInitializer redisInitializer) {
        return new RedissonTioClusterTopic(CLUSTER_TOPIC_CHANNEL, redisInitializer.getRedissonClient());
    }
}

