/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.literal;

import java.util.List;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.Literal;
import org.ssssssss.script.parsing.ast.statement.Spread;

public class ListLiteral
extends Literal {
    public final List<Expression> values;

    public ListLiteral(Span span, List<Expression> values) {
        super(span);
        this.values = values;
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        this.values.forEach(expr -> expr.visitMethod(compiler));
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        int size = this.values.size();
        if (size == 0) {
            compiler.newArrayList();
        } else {
            compiler.insn(this.values.stream().anyMatch(it -> it instanceof Spread) ? 4 : 3).asBoolean().newArray(this.values).call("newArrayList", 2);
        }
    }
}

