/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.datasource.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.event.EventListener;
import org.springframework.util.ClassUtils;
import org.ssssssss.magicapi.core.event.FileEvent;
import org.ssssssss.magicapi.core.service.AbstractMagicDynamicRegistry;
import org.ssssssss.magicapi.core.service.MagicResourceStorage;
import org.ssssssss.magicapi.datasource.model.DataSourceInfo;
import org.ssssssss.magicapi.datasource.model.MagicDynamicDataSource;

public class DataSourceMagicDynamicRegistry
extends AbstractMagicDynamicRegistry<DataSourceInfo> {
    private final MagicDynamicDataSource magicDynamicDataSource;
    private static final Logger logger = LoggerFactory.getLogger(DataSourceMagicDynamicRegistry.class);
    private static final ClassLoader CLASSLOADER = DataSourceMagicDynamicRegistry.class.getClassLoader();
    private static final String[] DATA_SOURCE_TYPE_NAMES = new String[]{"com.zaxxer.hikari.HikariDataSource", "org.apache.tomcat.jdbc.pool.DataSource", "org.apache.commons.dbcp2.BasicDataSource"};

    public DataSourceMagicDynamicRegistry(MagicResourceStorage<DataSourceInfo> magicResourceStorage, MagicDynamicDataSource magicDynamicDataSource) {
        super(magicResourceStorage);
        this.magicDynamicDataSource = magicDynamicDataSource;
    }

    @EventListener(condition="#event.type == 'datasource'")
    public void onFileEvent(FileEvent event) {
        try {
            this.processEvent(event);
        }
        catch (Exception e) {
            logger.error("\u6ce8\u518c\u6570\u636e\u6e90\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    protected boolean register(AbstractMagicDynamicRegistry.MappingNode<DataSourceInfo> mappingNode) {
        DataSourceInfo info = mappingNode.getEntity();
        HashMap<String, Object> properties = new HashMap<String, Object>(info.getProperties());
        if ("org.elasticsearch.xpack.sql.jdbc.EsDriver".equals(info.getDriverClassName())) {
            properties.put("defaultReadOnly", true);
        }
        properties.put("url", info.getUrl());
        properties.put("username", info.getUsername());
        properties.put("password", info.getPassword());
        if (StringUtils.isBlank((CharSequence)info.getDriverClassName())) {
            String driverClass = DatabaseDriver.fromJdbcUrl((String)info.getUrl()).getDriverClassName();
            properties.put("driverClassName", driverClass);
        } else {
            properties.put("driverClassName", info.getDriverClassName());
        }
        DataSource datasource = this.createDataSource(this.getDataSourceType(info.getType()), properties);
        this.magicDynamicDataSource.put(info.getId(), info.getKey(), info.getName(), datasource, info.getMaxRows());
        return true;
    }

    @Override
    protected void unregister(AbstractMagicDynamicRegistry.MappingNode<DataSourceInfo> mappingNode) {
        this.magicDynamicDataSource.delete(mappingNode.getMappingKey());
    }

    private DataSource createDataSource(Class<? extends DataSource> dataSourceType, Map<String, Object> properties) {
        DataSource dataSource = (DataSource)BeanUtils.instantiateClass(dataSourceType);
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(properties);
        ConfigurationPropertyNameAliases aliases = new ConfigurationPropertyNameAliases();
        aliases.addAliases("url", new String[]{"jdbc-url"});
        aliases.addAliases("username", new String[]{"user"});
        Binder binder = new Binder(new ConfigurationPropertySource[]{source.withAliases(aliases)});
        binder.bind(ConfigurationPropertyName.EMPTY, Bindable.ofInstance((Object)dataSource));
        return dataSource;
    }

    private Class<? extends DataSource> getDataSourceType(String datasourceType) {
        if (StringUtils.isNotBlank((CharSequence)datasourceType)) {
            try {
                return ClassUtils.forName((String)datasourceType, (ClassLoader)CLASSLOADER);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (String name : DATA_SOURCE_TYPE_NAMES) {
            try {
                return ClassUtils.forName((String)name, (ClassLoader)CLASSLOADER);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Override
    public List<DataSourceInfo> defaultMappings() {
        return this.magicDynamicDataSource.datasourceNodes().stream().filter(it -> it.getId() == null).map(it -> {
            DataSourceInfo dataSourceInfo = new DataSourceInfo();
            dataSourceInfo.setName((String)StringUtils.defaultIfBlank((CharSequence)it.getName(), (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)it.getKey(), (CharSequence)"\u9ed8\u8ba4\u6570\u636e\u6e90"))));
            dataSourceInfo.setKey(it.getKey());
            return dataSourceInfo;
        }).collect(Collectors.toList());
    }
}

