/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.ssssssss.magicapi.core.annotation.Valid;
import org.ssssssss.magicapi.core.config.MagicAPIProperties;
import org.ssssssss.magicapi.core.config.MagicConfiguration;
import org.ssssssss.magicapi.core.context.MagicUser;
import org.ssssssss.magicapi.core.exception.MagicLoginException;
import org.ssssssss.magicapi.core.interceptor.Authorization;
import org.ssssssss.magicapi.core.model.JsonBean;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.core.model.Options;
import org.ssssssss.magicapi.core.model.Plugin;
import org.ssssssss.magicapi.core.model.SelectedResource;
import org.ssssssss.magicapi.core.service.MagicAPIService;
import org.ssssssss.magicapi.core.servlet.MagicHttpServletRequest;
import org.ssssssss.magicapi.core.servlet.MagicHttpServletResponse;
import org.ssssssss.magicapi.core.web.MagicController;
import org.ssssssss.magicapi.core.web.MagicExceptionHandler;
import org.ssssssss.magicapi.modules.db.SQLModule;
import org.ssssssss.magicapi.utils.ClassScanner;
import org.ssssssss.magicapi.utils.IoUtils;
import org.ssssssss.magicapi.utils.SignUtils;
import org.ssssssss.magicapi.utils.WebUtils;
import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScriptEngine;
import org.ssssssss.script.ScriptClass;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.Tokenizer;

public class MagicWorkbenchController
extends MagicController
implements MagicExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(MagicWorkbenchController.class);
    private static final Pattern SINGLE_LINE_COMMENT_TODO = Pattern.compile("((TODO)|(todo)|(fixme)|(FIXME))[ \t]+[^\n]+");
    private static final Pattern MULTI_LINE_COMMENT_TODO = Pattern.compile("((TODO)|(todo)|(fixme)|(FIXME))[ \t]+[^\n(?!*/)]+");
    private final String secretKey;
    private final List<Plugin> plugins;
    private final MagicAPIProperties properties;
    private String allClassTxt;

    public MagicWorkbenchController(MagicConfiguration configuration, MagicAPIProperties properties, List<Plugin> plugins) {
        super(configuration);
        this.properties = properties;
        this.plugins = plugins;
        this.secretKey = properties.getSecretKey();
        MagicScriptEngine.addScriptClass(SQLModule.class);
        MagicScriptEngine.addScriptClass(MagicAPIService.class);
    }

    @GetMapping(value={"", "/"})
    @Valid(requireLogin=false)
    public String redirectIndex(MagicHttpServletRequest request) {
        if (request.getRequestURI().endsWith("/")) {
            return "redirect:./index.html";
        }
        return "redirect:" + this.properties.getWeb() + "/index.html";
    }

    @GetMapping(value={"/config.json"})
    @Valid(requireLogin=false)
    @ResponseBody
    public Map<String, Object> readConfig() {
        HashMap<String, Object> configJson = new HashMap<String, Object>();
        configJson.put("persistenceResponseBody", this.properties.isPersistenceResponseBody());
        configJson.put("version", this.properties.getVersion());
        configJson.put("web", this.properties.getWeb());
        configJson.put("prefix", this.properties.getPrefix());
        configJson.put("autoImportModuleList", this.properties.getAutoImportModuleList());
        configJson.put("autoImportPackage", this.properties.getAutoImportPackage());
        return configJson;
    }

    @GetMapping(value={"/classes.txt"}, produces={"text/plain"})
    @ResponseBody
    @Valid(requireLogin=false)
    private String readClass() {
        if (this.allClassTxt == null) {
            try {
                this.allClassTxt = ClassScanner.compress(ClassScanner.scan());
            }
            catch (Throwable t) {
                logger.warn("\u626b\u63cfClass\u5931\u8d25", t);
                this.allClassTxt = "";
            }
        }
        return this.allClassTxt;
    }

    @PostMapping(value={"/classes"})
    @ResponseBody
    @Valid(requireLogin=false)
    public JsonBean<Map<String, Object>> classes() {
        Map classMap = MagicScriptEngine.getScriptClassMap();
        classMap.putAll(MagicResourceLoader.getModules());
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("classes", classMap);
        values.put("extensions", MagicScriptEngine.getExtensionScriptClass());
        values.put("functions", MagicScriptEngine.getFunctions());
        return new JsonBean<Map<String, Object>>(values);
    }

    @PostMapping(value={"/class"})
    @ResponseBody
    public JsonBean<Set<ScriptClass>> clazz(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return new JsonBean<Set<ScriptClass>>(Collections.emptySet());
        }
        return new JsonBean<Set<ScriptClass>>(MagicScriptEngine.getScriptClass((String)className));
    }

    @PostMapping(value={"/login"})
    @ResponseBody
    @Valid(requireLogin=false)
    public JsonBean<Boolean> login(String username, String password, MagicHttpServletRequest request, MagicHttpServletResponse response) throws MagicLoginException {
        if (this.configuration.getAuthorizationInterceptor().requireLogin()) {
            if (StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)password)) {
                try {
                    this.configuration.getAuthorizationInterceptor().getUserByToken(request.getHeader("Magic-Token"));
                }
                catch (MagicLoginException ignored) {
                    return new JsonBean<Boolean>(false);
                }
            } else {
                MagicUser user = this.configuration.getAuthorizationInterceptor().login(username, password);
                response.setHeader("Magic-Token", user.getToken());
                response.setHeader("Access-Control-Expose-Headers", "Magic-Token");
            }
        }
        return new JsonBean<Boolean>(true);
    }

    @PostMapping(value={"/user"})
    @ResponseBody
    public JsonBean<MagicUser> user(MagicHttpServletRequest request) {
        if (this.configuration.getAuthorizationInterceptor().requireLogin()) {
            try {
                return new JsonBean<MagicUser>(this.configuration.getAuthorizationInterceptor().getUserByToken(request.getHeader("Magic-Token")));
            }
            catch (MagicLoginException magicLoginException) {
                // empty catch block
            }
        }
        return new JsonBean<MagicUser>(MagicUser.guest());
    }

    @PostMapping(value={"/logout"})
    @ResponseBody
    @Valid(requireLogin=false)
    public JsonBean<Void> logout(MagicHttpServletRequest request) {
        this.configuration.getAuthorizationInterceptor().logout(request.getHeader("Magic-Token"));
        return new JsonBean<Void>();
    }

    @GetMapping(value={"/plugins"})
    @Valid(requireLogin=false)
    @ResponseBody
    public JsonBean<List<Plugin>> plugins() {
        return new JsonBean<List<Plugin>>(this.plugins);
    }

    @RequestMapping(value={"/options"})
    @ResponseBody
    @Valid(requireLogin=false)
    public JsonBean<List<List<String>>> options() {
        return new JsonBean<List<List<String>>>(Stream.of(Options.values()).map(item -> Arrays.asList(item.getValue(), item.getName(), item.getDefaultValue())).collect(Collectors.toList()));
    }

    @GetMapping(value={"/reload"})
    @ResponseBody
    public JsonBean<Boolean> reload(MagicHttpServletRequest request) {
        this.isTrue(this.allowVisit(request, Authorization.RELOAD), PERMISSION_INVALID);
        MagicConfiguration.getMagicResourceService().refresh();
        return new JsonBean<Boolean>(true);
    }

    @PostMapping(value={"/search"})
    @ResponseBody
    public JsonBean<List<Map<String, Object>>> search(String keyword, MagicHttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)keyword)) {
            return new JsonBean<List<Map<String, Object>>>(Collections.emptyList());
        }
        return new JsonBean<List<Map<String, Object>>>(this.entities(request, Authorization.VIEW).stream().filter(it -> it.getScript().contains(keyword)).map(it -> {
            String script = it.getScript();
            int index = script.indexOf(keyword);
            int endIndex = script.indexOf("\n", index + keyword.length());
            index = script.lastIndexOf("\n", index) + 1;
            final Span span = new Span(script, index, endIndex == -1 ? script.length() : endIndex);
            return new HashMap<String, Object>(){
                {
                    this.put("id", it.getId());
                    this.put("text", span.getText().trim());
                    this.put("line", span.getLine().getLineNumber());
                }
            };
        }).collect(Collectors.toList()));
    }

    @GetMapping(value={"/todo"})
    @ResponseBody
    @Valid
    public JsonBean<List<Map<String, Object>>> todo(MagicHttpServletRequest request) {
        List<MagicEntity> entities = this.entities(request, Authorization.VIEW);
        ArrayList<2> result = new ArrayList<2>(entities.size());
        for (final MagicEntity entity : entities) {
            try {
                List comments = Tokenizer.tokenize((String)entity.getScript(), (boolean)true).comments();
                for (final Span comment : comments) {
                    String text = comment.getText();
                    Pattern pattern = text.startsWith("//") ? SINGLE_LINE_COMMENT_TODO : MULTI_LINE_COMMENT_TODO;
                    final Matcher matcher = pattern.matcher(text);
                    while (matcher.find()) {
                        result.add(new HashMap<String, Object>(){
                            {
                                this.put("id", entity.getId());
                                this.put("text", matcher.group(0).trim());
                                this.put("line", comment.getLine().getLineNumber());
                            }
                        });
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        return new JsonBean<List<Map<String, Object>>>(result);
    }

    @RequestMapping(value={"/config-js"})
    @ResponseBody
    @Valid(requireLogin=false)
    public void configJs(MagicHttpServletResponse response) throws IOException {
        response.setContentType("application/javascript");
        response.setCharacterEncoding("UTF-8");
        byte[] bytes = "var MAGIC_EDITOR_CONFIG = {}".getBytes();
        if (this.configuration.getEditorConfig() != null) {
            try {
                String path = this.configuration.getEditorConfig();
                if (path.startsWith("classpath:")) {
                    path = path.substring("classpath:".length());
                    bytes = IoUtils.bytes(new ClassPathResource(path).getInputStream());
                } else {
                    File file = ResourceUtils.getFile((String)this.configuration.getEditorConfig());
                    bytes = Files.readAllBytes(Paths.get(file.toURI()));
                }
            }
            catch (IOException e) {
                logger.warn("\u8bfb\u53d6\u7f16\u8f91\u5668\u914d\u7f6e\u6587\u4ef6{}\u5931\u8d25", (Object)this.configuration.getEditorConfig());
            }
        }
        try (OutputStream stream = response.getOutputStream();){
            stream.write(bytes);
            stream.flush();
        }
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    @Valid(authorization=Authorization.DOWNLOAD)
    public void download(String groupId, @RequestBody(required=false) List<SelectedResource> resources, MagicHttpServletRequest request, MagicHttpServletResponse response) throws IOException {
        this.isTrue(this.allowVisit(request, Authorization.DOWNLOAD), PERMISSION_INVALID);
        response.setContentType("application/octet-stream");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.magicAPIService.download(groupId, resources, os);
        String filename = "magic-api-all.zip";
        if (StringUtils.isBlank((CharSequence)groupId)) {
            filename = "magic-api-group.zip";
        }
        response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(filename, "UTF-8"));
        try (OutputStream stream = response.getOutputStream();){
            stream.write(os.toByteArray());
            stream.flush();
        }
    }

    @RequestMapping(value={"/upload"})
    @Valid(readonly=false, authorization=Authorization.UPLOAD)
    @ResponseBody
    public JsonBean<Boolean> upload(MultipartFile file, String mode, MagicHttpServletRequest request) throws IOException {
        this.notNull(file, FILE_IS_REQUIRED);
        this.isTrue(this.allowVisit(request, Authorization.UPLOAD), PERMISSION_INVALID);
        if (this.configuration.getMagicBackupService() != null) {
            this.configuration.getMagicBackupService().doBackupAll("\u4e0a\u4f20\u524d\uff0c\u7cfb\u7edf\u81ea\u52a8\u5168\u91cf\u5907\u4efd", WebUtils.currentUserName());
        }
        return new JsonBean<Boolean>(this.magicAPIService.upload(file.getInputStream(), mode));
    }

    @RequestMapping(value={"/push"})
    @ResponseBody
    @Valid(authorization=Authorization.PUSH)
    public JsonBean<?> push(@RequestHeader(value="magic-push-target") String target, @RequestHeader(value="magic-push-secret-key") String secretKey, @RequestHeader(value="magic-push-mode") String mode, @RequestBody List<SelectedResource> resources, MagicHttpServletRequest request) {
        this.isTrue(this.allowVisit(request, Authorization.PUSH), PERMISSION_INVALID);
        return this.magicAPIService.push(target, secretKey, mode, resources);
    }

    @ResponseBody
    @Valid(requireLogin=false)
    public JsonBean<Void> receivePush(MultipartFile file, String mode, Long timestamp, String sign) throws IOException {
        this.notNull(timestamp, SIGN_IS_INVALID);
        this.notBlank(mode, SIGN_IS_INVALID);
        this.notBlank(sign, SIGN_IS_INVALID);
        this.notNull(file, SIGN_IS_INVALID);
        byte[] bytes = IoUtils.bytes(file.getInputStream());
        this.isTrue(sign.equals(SignUtils.sign(timestamp, this.secretKey, mode, bytes)), SIGN_IS_INVALID);
        if (this.configuration.getMagicBackupService() != null) {
            this.configuration.getMagicBackupService().doBackupAll("\u63a8\u9001\u524d\uff0c\u7cfb\u7edf\u81ea\u52a8\u5168\u91cf\u5907\u4efd", WebUtils.currentUserName());
        }
        this.magicAPIService.upload(new ByteArrayInputStream(bytes), mode);
        return new JsonBean<Void>();
    }
}

