/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.ssssssss.magicapi.core.config.Backup;
import org.ssssssss.magicapi.core.config.Cache;
import org.ssssssss.magicapi.core.config.Crud;
import org.ssssssss.magicapi.core.config.Debug;
import org.ssssssss.magicapi.core.config.Page;
import org.ssssssss.magicapi.core.config.Resource;
import org.ssssssss.magicapi.core.config.ResponseCode;
import org.ssssssss.magicapi.core.config.Security;
import org.ssssssss.magicapi.core.web.RequestHandler;

@ConfigurationProperties(prefix="magic-api")
public class MagicAPIProperties {
    private final String version = RequestHandler.class.getPackage().getImplementationVersion();
    private String web;
    private String prefix;
    private boolean banner = true;
    private boolean throwException = false;
    private String autoImportModule = "db";
    private String autoImportPackage;
    private boolean allowOverride = false;
    private String sqlColumnCase = "default";
    private int threadPoolExecutorSize = 0;
    private String editorConfig;
    private boolean supportCrossDomain = true;
    private String response;
    private String secretKey;
    private String pushPath = "/_magic-api-sync";
    private boolean showUrl = true;
    private boolean showSql = true;
    private String[] datePattern = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyyMMddHHmmss", "yyyyMMdd"};
    private int compileCacheSize = 500;
    private boolean persistenceResponseBody = true;
    private String instanceId = UUID.randomUUID().toString();
    @NestedConfigurationProperty
    private Security security = new Security();
    @NestedConfigurationProperty
    private Page page = new Page();
    @NestedConfigurationProperty
    private Cache cache = new Cache();
    @NestedConfigurationProperty
    private Debug debug = new Debug();
    @NestedConfigurationProperty
    private Resource resource = new Resource();
    @NestedConfigurationProperty
    private ResponseCode responseCode = new ResponseCode();
    @NestedConfigurationProperty
    private Crud crud = new Crud();
    @NestedConfigurationProperty
    private Backup backup = new Backup();

    public String getWeb() {
        if (StringUtils.isBlank((CharSequence)this.web)) {
            return null;
        }
        if (this.web.endsWith("/**")) {
            return this.web.substring(0, this.web.length() - 3);
        }
        if (this.web.endsWith("/*")) {
            return this.web.substring(0, this.web.length() - 2);
        }
        if (this.web.endsWith("/")) {
            return this.web.substring(0, this.web.length() - 1);
        }
        return this.web;
    }

    public void setWeb(String web) {
        this.web = web;
    }

    public String getSqlColumnCase() {
        return this.sqlColumnCase;
    }

    public void setSqlColumnCase(String sqlColumnCase) {
        this.sqlColumnCase = sqlColumnCase;
    }

    public boolean isBanner() {
        return this.banner;
    }

    public void setBanner(boolean banner) {
        this.banner = banner;
    }

    public List<String> getAutoImportModuleList() {
        return Arrays.asList(this.autoImportModule.replaceAll("\\s", "").split(","));
    }

    public List<String> getAutoImportPackageList() {
        if (this.autoImportPackage == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.autoImportPackage.replaceAll("\\s", "").split(","));
    }

    public String getVersion() {
        return this.version;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public String getAutoImportModule() {
        return this.autoImportModule;
    }

    public void setAutoImportModule(String autoImportModule) {
        this.autoImportModule = autoImportModule;
    }

    public String getAutoImportPackage() {
        return this.autoImportPackage;
    }

    public void setAutoImportPackage(String autoImportPackage) {
        this.autoImportPackage = autoImportPackage;
    }

    public boolean isAllowOverride() {
        return this.allowOverride;
    }

    public void setAllowOverride(boolean allowOverride) {
        this.allowOverride = allowOverride;
    }

    public int getThreadPoolExecutorSize() {
        return this.threadPoolExecutorSize;
    }

    public void setThreadPoolExecutorSize(int threadPoolExecutorSize) {
        this.threadPoolExecutorSize = threadPoolExecutorSize;
    }

    public String getEditorConfig() {
        return this.editorConfig;
    }

    public void setEditorConfig(String editorConfig) {
        this.editorConfig = editorConfig;
    }

    public boolean isSupportCrossDomain() {
        return this.supportCrossDomain;
    }

    public void setSupportCrossDomain(boolean supportCrossDomain) {
        this.supportCrossDomain = supportCrossDomain;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getPushPath() {
        return this.pushPath;
    }

    public void setPushPath(String pushPath) {
        this.pushPath = pushPath;
    }

    public boolean isShowUrl() {
        return this.showUrl;
    }

    public void setShowUrl(boolean showUrl) {
        this.showUrl = showUrl;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public String[] getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String[] datePattern) {
        this.datePattern = datePattern;
    }

    public int getCompileCacheSize() {
        return this.compileCacheSize;
    }

    public void setCompileCacheSize(int compileCacheSize) {
        this.compileCacheSize = compileCacheSize;
    }

    public boolean isPersistenceResponseBody() {
        return this.persistenceResponseBody;
    }

    public void setPersistenceResponseBody(boolean persistenceResponseBody) {
        this.persistenceResponseBody = persistenceResponseBody;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public void setDebug(Debug debug) {
        this.debug = debug;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public ResponseCode getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(ResponseCode responseCode) {
        this.responseCode = responseCode;
    }

    public Crud getCrud() {
        return this.crud;
    }

    public void setCrud(Crud crud) {
        this.crud = crud;
    }

    public Backup getBackup() {
        return this.backup;
    }

    public void setBackup(Backup backup) {
        this.backup = backup;
    }
}

